/*
** smbuttod.h
**
** Private device-dependent header for TWS buttons.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 19 May 1992
** Original version
*/

#ifndef SMBUTTOP_H
#define SMBUTTOP_H

#include "smbutton.h"                   /* Button header                    */
#include "smgadget.h"

/*
** Function prototypes
*/
int     ButtonProc(GadgetType *c, EventType *ev);
void    ClearButton(ButtonType *b);
int     DestroyButton(GadgetType *g);
int     DrawButton(GadgetType *g);
int     DrawButtonLabel(ButtonType *b);
void    PushButton(GadgetType *g, short *x, short *y);
void    UnpushButton(GadgetType *b);

int     smButtonUpArrow(ButtonType *b);
int     smButtonDownArrow(ButtonType *b);
int     smButtonRightArrow(ButtonType *b);
int     smButtonLeftArrow(ButtonType *b);

#endif
