/*
** wintestp.c
**
** Test of graphics image routines
**
**
** Copyright 1994 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
** All rights reserved
**
*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <smtypes.h>
#include <smwindow.h>
#include <smevent.h>
#include <smgraph.h>
#include <smlabel.h>
#include <smcolor.h>

#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif

int main(int argc, char *argv[])
{
    WindowType  *w1, *w2;
    ImageType   *img;
    RectType    r, lablr1;
    EventType   *ev;
    int         msg;
    char        key, code;
    LabelType   *label1;
    int         i = 0;
    long        size;
    int         n;

    SM_Init(argc, argv);

    SM_OpenApplication("TWS : Graphics Image Demo", NULL);

    /*
    ** Create a couple of windows
    */
    r.Xmin = r.Ymin = 100;
    r.Xmax = 350;
    r.Ymax = 200;
    w1 = SM_NewWindow(&r, "Image Demo 1", DIALOG, NULL, NULL);
    r.Xmin = r.Ymin = 290;
    r.Xmax = 550;
    r.Ymax = 400;
    w2 = SM_NewWindow(&r, "Image Demo 2", DIALOG, NULL, NULL);
    GR_CreateGraphState(w1, NULL, SMDEFAULT);
    GR_CreateGraphState(w2, NULL, SMDEFAULT);
    SM_OpenWindow(w2);
    SM_OpenWindow(w1);

    /*
    ** Fill one window with a random pattern
    */
    randomize();
    for (n = 0; n < 3000; n++) {
        GR_SetDrawColor(w1, SM_GetSystemColor(random(7)+1));
        GR_DrawPoint(w1, random(250), random(100));
    }

    /*
    ** Set the rectangle for the captured image
    */
    r.Xmin = 5;
    r.Ymin = 5;
    r.Xmax = 75;
    r.Ymax = 50;

    lablr1.Xmin = lablr1.Ymin = 1;
    lablr1.Xmax = lablr1.Xmin + SM_StringWidth(" Grabbing image from this window... ",
                                               SM_GetSystemFont(),
                                               TXTPROPORTIONAL);
    lablr1.Ymax = lablr1.Ymin + SM_GetSystemFontHeight() + 4;
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_GetEventKey(ev, &key, &code);
            if (toupper(key) == 'Q') {
                SM_Exit(NULL);
            }
            else if (!i) {
                i++;
                label1 = SM_CreateLabel(w1,
                                        &lablr1,
                                        "Grabbing image from this window...",
                                        NULL,
                                        ALIGNLEFT,
                                        False,
                                        False,
                                        True,
                                        NULL);
                size = GR_ImageSize(&r);
                if (size < GRMAXIMAGE) {
                    img = (ImageType *)malloc((size_t)size);
                    GR_GetImage(w1, &r, img);
                }
            }
            else if (i == 1) {
                i++;
                SM_BringToFront(w2);
                SM_CreateLabel(w2,              /* Parent window            */
                               &lablr1,         /* Boundary rectangle       */
                               "Putting it in this window.",
                               NULL,            /* Graph procedure          */
                               ALIGNLEFT,       /* Horizontal alignment     */
                               False,           /* Bold text flag           */
                               False,           /* Italic text flag         */
                               True,            /* Boundary flag            */
                               NULL);           /* User data                */
                GR_ShiftRect(&r, 25, 25);
                GR_PutImage(w2, &r, img);
                free(img);
            }
            else {
                SM_Exit(NULL);
            }
        }
    }
}




