/*
** wintesto.c
**
** Test of event return values
**
**
** Copyright 1994 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
** All rights reserved
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <smtypes.h>
#include <smwindow.h>
#include <smevent.h>
#include <smlabel.h>

#ifdef __TURBOC__
extern unsigned _stklen = 16384U;
#endif

extern FILE *ferr;


int main(int argc, char **argv)
{
    WindowType  *w;
    LabelType   *label1, *label2, *label3, *label4;
    char        msgstr[80], typestr[80], managestr[80], regionstr[80];
    RectType    r;
    EventType   *ev;
    int         msg;
    int         oldtype = -1, oldmsg = -1, oldman = -1, oldreg = -1;

    ferr = NULL;
    SM_Init(argc, argv);

    SM_OpenApplication("TWS Demo : Event return values", NULL);

    r.Xmin = r.Ymin = 50;
    r.Xmax = r.Ymax = 250;

    w = SM_NewWindow(&r, "Event Demo", DOCUMENT, NULL, NULL);

    managestr[0] = 0;
    r.Xmin = r.Ymin = 1;
    r.Xmax = 249;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    label1 = SM_CreateLabel(w,
                            &r,
                            "Msg returned :",
                            NULL,
                            ALIGNLEFT,
                            False,
                            False,
                            False,
                            NULL);
    r.Ymin = r.Ymax + 2;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    label2 = SM_CreateLabel(w,
                            &r,
                            "Event type :",
                            NULL,
                            ALIGNLEFT,
                            False,
                            False,
                            False,
                            NULL);
    r.Ymin = r.Ymax + 2;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    label3 = SM_CreateLabel(w,
                            &r,
                            "Manage event :",
                            NULL,
                            ALIGNLEFT,
                            False,
                            False,
                            False,
                            NULL);
    r.Ymin = r.Ymax + 2;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    label4 = SM_CreateLabel(w,
                            &r,
                            "Region :",
                            NULL,
                            ALIGNLEFT,
                            False,
                            False,
                            False,
                            NULL);
    SM_OpenWindow(w);

    if (ferr == NULL) {
        ferr = fopen("wintesto.out","wb");
    }

    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg != oldmsg) {
            sprintf(msgstr, "Msg returned : %d", msg);
            fprintf(ferr, "%s\n",msgstr);
            SM_SetLabelString(label1, msgstr);
            oldmsg = msg;
        }
        if (ev->event_type != oldtype) {
            switch(ev->event_type) {
                case RIGHTBUTTONACTIVE :
                    sprintf(typestr, "Event type : RIGHTBUTTONACTIVE");
                    break;
                case MIDDLEBUTTONACTIVE :
                    sprintf(typestr, "Event type : MIDDLEBUTTONACTIVE");
                    break;
                case LEFTBUTTONACTIVE :
                    sprintf(typestr, "Event type : LEFTBUTTONACTIVE");
                    break;
                case ANYBUTTONACTIVE :
                    sprintf(typestr, "Event type : ANYBUTTONACTIVE");
                    break;
                case RIGHTBUTTONDOWN :
                    sprintf(typestr, "Event type : RIGHTBUTTONDOWN");
                    break;
                case MIDDLEBUTTONDOWN :
                    sprintf(typestr, "Event type : MIDDLEBUTTONDOWN");
                    break;
                case LEFTBUTTONDOWN :
                    sprintf(typestr, "Event type : LEFTBUTTONDOWN");
                        break;
                case ANYBUTTONDOWN :
                    sprintf(typestr, "Event type : ANYBUTTONDOWN");
                    break;
                case ANYBUTTONUP :
                    sprintf(typestr, "Event type : ANYBUTTONUP");
                    break;
                case DOUBLECLICK :
                    sprintf(typestr, "Event type : DOUBLECLICK");
                    break;
                case CLOCKTICK :
                    sprintf(typestr, "Event type : CLOCKTICK");
                    break;
                case CURSORMOVE :
                    sprintf(typestr, "Event type : CURSORMOVE");
                    break;
                case KEYPRESS :
                    sprintf(typestr, "Event type : KEYPRESS");
                    break;
                case ENTERKEY :
                    sprintf(typestr, "Event type : ENTERKEY");
                    break;
            }
            fprintf(ferr, "%s\n", typestr);
            SM_SetLabelString(label2, typestr);
            oldtype = ev->event_type;
        }
        if (ev->manage_event != oldman) {
            switch(ev->manage_event) {
                case EV_NONE :
                    sprintf(managestr, "Manage event : EV_NONE");
                    break;
                case EV_WINMOVE :
                    sprintf(managestr, "Manage event : EV_WINMOVE");
                    break;
                case EV_WINMENU :
                    sprintf(managestr, "Manage event : EV_WINMENU");
                    break;
                case EV_BASEMENU :
                    sprintf(managestr, "Manage event : EV_BASEMENU");
                    break;
                case EV_CHANGEWIN :
                    sprintf(managestr, "Manage event : EV_CHANGEWIN");
                    break;
                case EV_NEWWIN :
                    sprintf(managestr, "Manage event : EV_NEWWIN");
                    break;
                case EV_CLOSEWIN :
                    sprintf(managestr, "Manage event : EV_CLOSEWIN");
                    break;
                case EV_WINSIZE :
                    sprintf(managestr, "Manage event : EV_WINSIZE");
                    break;
            }
            fprintf(ferr, "%s\n", managestr);
            SM_SetLabelString(label3, managestr);
            oldman = ev->manage_event;
        }
        if (ev->region != oldreg) {
            switch(ev->region) {
                case UP :
                    sprintf(regionstr, "Region : UP");
                    break;
                case DOWN :
                    sprintf(regionstr, "Region : DOWN");
                    break;
                case LEFT :
                    sprintf(regionstr, "Region : LEFT");
                    break;
                case RIGHT :
                    sprintf(regionstr, "Region : RIGHT");
                    break;
                case UPLEFT :
                    sprintf(regionstr, "Region : UPLEFT");
                    break;
                case UPRIGHT :
                    sprintf(regionstr, "Region : UPRIGHT");
                    break;
                case DOWNLEFT :
                    sprintf(regionstr, "Region : DOWNLEFT");
                    break;
                case DOWNRIGHT :
                    sprintf(regionstr, "Region : DOWNRIGHT");
                    break;
                case MOVE_REGION :
                    sprintf(regionstr, "Region : MOVE_REGION");
                    break;
                case CLOSE_REGION :
                    sprintf(regionstr, "Region : CLOSE_REGION");
                    break;
                case MENU_REGION :
                    sprintf(regionstr, "Region : MENU_REGION");
                    break;
                case BASE_MENU_REGION :
                    sprintf(regionstr, "Region : BASE_MENU_REGION");
                    break;
                case WINDOW_REGION :
                    sprintf(regionstr, "Region : WINDOW_REGION");
                    break;
                case MAXIMIZE_REGION :
                    sprintf(regionstr, "Region : MAXIMIZE_REGION");
                    break;
                case CONTENT_REGION :
                    sprintf(regionstr, "Region : CONTENT_REGION");
                    break;
                case WORKSPACE_REGION :
                    sprintf(regionstr, "Region : WORKSPACE_REGION");
                    break;
                case MINIMIZE_REGION :
                    sprintf(regionstr, "Region : MINIMIZE_REGION");
                    break;
                case CANVAS_REGION :
                    sprintf(regionstr, "Region : CANVAS_REGION");
                    break;
                case APP_TITLE_REGION :
                    sprintf(regionstr, "Region : APP_TITLE_REGION");
                    break;
            }
            SM_SetLabelString(label4, regionstr);
            oldreg = ev->region;
            fprintf(ferr, "%s\n", regionstr);
        }
        if (msg == KEYPRESS) {
            if (ev->ASCII == 'q') {
                SM_Exit(NULL);
            }
        }
    }
}




