/*
** wintestm.c
**
** Test 21 of the SM window system.
** RotateList test
**
** Copyright 1994 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smwutil.h"
#include "smmulti.h"

extern FILE *ferr;
int Sout(RotatelistType *s);
void PrntScrn(WindowType *w, RectType *r, char *fname);;

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    RotatelistType  *s;
    RectType    rt;
    char        *list[10];

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : RotateList Gadget", NULL);

    /*
    ** Create a string list
    */
    list[0] = "0:This";
    list[1] = "1:is a";
    list[2] = "2:RotateList";
    list[3] = "3:gadget";
    list[4] = "4:from";
    list[5] = "5:the";
    list[6] = "6:TWS";
    list[7] = "7:Windowing";
    list[8] = "8:system.";
    list[9] = NULL;
    rt.Xmin = rt.Ymin = 150;
    rt.Xmax = rt.Xmin + 150;
    rt.Ymax = rt.Ymin + 2*SM_GetSystemFontHeight();

    s = SM_CreateRotatelist(SM_WorkspaceWindow(),
                            &rt,        /* Bounding rectangle               */
                            list,       /* List of strings to display       */
                            ALIGNLEFT,  /* String alignment in display      */
                            Sout,       /* Application function             */
                            NULL);      /* User data                        */

    SM_SetPrintscreenProc(NULL, NULL, "panel.pcx", PrntScrn);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintestm.out","wb");
    }
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if ((ev->ASCII >= '0') && (ev->ASCII <= '9')) {
                msg = (ev->ASCII - '0');
                fprintf(ferr, "  Setting position to %d\n", msg);
                SM_SetRotatelistSelected(s, msg);
            }
            else {
                SM_Exit(NULL);
            }
        }
    }
}



int Sout(RotatelistType *s)
{
    fprintf(ferr, "String selected = %s\n", SM_GetRotatelistString(s));
    return True;
}


void PrntScrn(WindowType *w, RectType *r, char *fname)
{
    SM_SaveScreenAsPCX(fname);
}


