/*
** wintestc.c
**
** Test 12 of the SM window system.
** Label test
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smcolor.h"
#include "smgraph.h"
#include "smlabel.h"


main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    LabelType   *label;
    RectType    rt;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Label Gadget", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+247;
    w = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | NOBACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Create a label
    */
    rt.Xmin = rt.Ymin = 8;
    rt.Xmax = rt.Xmin + GR_StringWidth(" Unboxed Label ");
    rt.Ymax = rt.Ymin + 6 + SM_GetSystemFontHeight();
    label = SM_CreateLabel(w,
                           &rt,             /* Label bounding box           */
                           "Unboxed Label", /* String for label             */
                           NULL,            /* Label procedure              */
                           ALIGNLEFT,       /* Label string alignment       */
                           False,           /* Bold flag                    */
                           False,           /* Italic flag                  */
                           False,           /* Box flag                     */
                           NULL);           /* User data                    */
    rt.Ymin = rt.Ymax + 8;
    rt.Ymax = rt.Ymin + 6 + SM_GetSystemFontHeight();
    label = SM_CreateLabel(w,
                           &rt,             /* Label bounding box           */
                           "Boxed Label",   /* String for label             */
                           NULL,            /* Label procedure              */
                           ALIGNLEFT,       /* Label string alignment       */
                           False,           /* Bold flag                    */
                           False,           /* Italic flag                  */
                           True,            /* Box flag                     */
                           NULL);           /* User data                    */
    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}

