/*
** wintest9.c
**
** Test 9 of the SM window system.
** Test of canvas region save-under
**
** This program tests:
**
**    * Allocating and setting a window color palette
**    * User Draw procedure
**    * Drawing in a window canvas
**    * Saving canvas contents to disk, restoring them
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Thu  07-02-1992
** Original version
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"
#include "smcolor.h"
#include "smgraph.h"

extern FILE *ferr;
int Win_Draw(WindowType *w);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    RectType    rt;
    int         i, r, g, b;

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Canvas Region Save-under", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 400;
    w = SM_NewWindow(&rt, "Test Window", DOCUMENT | BACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Create a graphics state for the window so we can draw in it
    */
    GR_CreateGraphState(w, NULL, False);

    /*
    ** Allocate a color table for this window...
    */
    SM_CreateWindowPalette(w, 247);
    r = g = b = 32;
    for (i = 0; i < 247; i++) {
        SM_SetWindowColor(w, i, r, g, b, SMSHARE | SMCLOSESTCOLOR);
        b += 48;
        if (b >= 256) {
            b -= 2*g;
            g += 4;
            if (g >= 256) {
                g -= 2*r;
                r += 4;
            }
        }
    }

    SM_SetDrawProc(w, Win_Draw);
    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintest9.out", "wb");
    }
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}


int Win_Draw(WindowType *w)
{
    int x, y;
    int i , j, k;

    x = GR_GetCanvasWidth(w);
    y = GR_GetCanvasDepth(w);
    k = 0;
    for (i = 0; i < y; i++) {
        for (j = 0; j < x; j++) {
            GR_SetDrawColor(w, SM_GetWindowColor(w, k));
            GR_DrawPoint(w, j, i);
            k++;
            if (k == 247) {
                k = 0;
            }
        }
    }
}
