/*
** wintest8.c
**
** Test 8 of the SM window system.
** Test of the window color palette system and elementary graphics.
**
** This program tests:
**
**    * Allocating and setting a window color palette
**    * User Draw procedure
**    * Drawing in a window canvas
**
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"
#include "smcolor.h"
#include "smgraph.h"

int Win_Draw(WindowType *w);

#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    RectType    rt;
    int         i, r, g, b;
    int         dr, db, dg;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : LUT Color Graphics", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = rt.Xmin + 256;
    w = SM_NewWindow(&rt, "Test Window", DOCUMENT | NOBACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Create a graphics state for the window so we can draw in it
    */
    GR_CreateGraphState(w, NULL, False);

    /*
    ** Allocate a color table for this window...
    */
    SM_CreateWindowPalette(w, 247);
    r = g = 4;
    b = 127;
    db = 4;
    dg = 6;
    dr = 8;
    for (i = 0; i < 247; i++) {
        SM_SetWindowColor(w, i, r, g, b, SMSHARE | SMCLOSESTCOLOR);
        b += db;
        if ((b >= 255) || (b <= 0)) {
            if (b > 10) b = 255;
            else b = 0;
            g += dg;
            if ((g >= 255) || (g <= 0)) {
                if (g > 10) g = 255;
                else g = 0;
                r += dr;
                if ((r >= 255) || (r <= 0)) {
                    if (r > 10) r = 255;
                    else r = 0;
                    dg = -dg;
                    db = -db;
                    dr = -dr;
                }
            }
        }
    }

    SM_SetDrawProc(w, Win_Draw);
    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}


int Win_Draw(WindowType *w)
{
    int x, y;
    int i , j, k, inc;

    x = GR_GetCanvasWidth(w);
    y = GR_GetCanvasDepth(w);
    k = 0;
    inc = 1;
    for (i = 0; i < y; i++) {
        GR_SetDrawColor(w, SM_GetWindowColor(w, k));
        GR_DrawLine(w, 0,i,x,i);
        k += inc;
        if (k == 246) {
            inc = -inc;
        }
    }
}
