/*
** wintestm.c
**
** Test 22 of the SM window system.
** 'Triserract' demo program.
**
** Dean Clark
** Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Wed  08-05-1992
** Original version
*/

/*
** Borlandc requires extra stack
*/
#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"
#include "smgraph.h"
#include "smcolor.h"
#include "smtext.h"
#include "smbutton.h"
#include "smlabel.h"


int Lines(WindowType *w, EventType *ev);
int ResizeWin(WindowType *w);
int CloseWin(WindowType *w);
int ResizeText(WindowType *w);
int HowItWorks(WindowType *w);
int About(WindowType *w);
int CloseAbout(ButtonType *b);

BackgroundProcIDType    id1;

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    BackgroundProcIDType  id;
    MenuType    *m;
    int         r,g,b,i;
    RectType    rt;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Demo menu is very simple
    */
    m = SM_CreateMenu();
    SM_AddMenuItem(m, ACTION_ITEM, "About...", About, NULL);
    SM_AddMenuItem(m, ACTION_ITEM, "Source Code", HowItWorks, NULL);
    SM_AddMenuItem(m, ACTION_ITEM, "Quit", SM_Exit, NULL);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Teserract", m);

    rt.Xmin = rt.Ymin = 100;
    rt.Xmax = rt.Xmin + 250;
    rt.Ymax = rt.Ymin + 250;
    w = SM_NewWindow(&rt, "Triserract", DOCUMENT | NOBACKING, NULL, NULL);
    GR_CreateGraphState(w, NULL, SMDEFAULT);

    /*
    ** Initialize the event handling system and attach the line drawing
    ** function to it
    */
    SM_InitBackgroundProcs();

    if (SM_nSystemColors() > 16) {
        SM_CreateWindowPalette(w, 247);
        for (i = 0; i < 64; i++) {
            b = 0;
            r = 4*i;
            g = 0;
            SM_SetWindowColor(w, i, r, g, b, SMSHARE);
        }
        for (i = 0; i < 64; i++) {
            b = 0;
            r = 255-4*i;
            g = 4*i;
            SM_SetWindowColor(w, i+64, r, g, b, SMSHARE);
        }
        for (i = 0; i < 64; i++) {
            b = 4*i;
            r = 0;
            g = 255-4*i;
            SM_SetWindowColor(w, i+128, r, g, b, SMSHARE);
        }
        for (i = 0; i < 55; i++) {
            b = 255;
            r = 4*i;
            g = 4*i;
            SM_SetWindowColor(w, i+192, r, g, b, SMSHARE);
        }
    }
    else {
        SM_CreateWindowPalette(w, 8);
        for (i = 0; i < 8; i++) {
            b = 255-32*i;
            r = 24*i;
            g = 24*i;
            SM_SetWindowColor(w, i, r, g, b, SMSHARE);
        }
    }

    id1 = SM_RegisterBackgroundProc(w, Lines, ALLEVENTS | NOTOBSCURED);

    SM_SetResizeProc(w, ResizeWin);
    SM_SetCloseProc(w, CloseWin);
    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
    }
}

int ResizeWin(WindowType *w)
{
    RectType    r;

    r.Xmin = r.Ymin = 0;
    r.Xmax = SM_GetContentWidth(w);
    r.Ymax = SM_GetContentDepth(w);

    GR_SetCanvasRect(w, &r);
    GR_ClearCanvas(w);
}



int CloseWin(WindowType *w)
{
    SM_RemoveBackgroundProc(id1);
}

int Lines(WindowType *w, EventType *ev)
{
    static int lx = 50, ly = 50, rx = 700, ry = 700, x3 = 325, y3 = 250;
    static int ldx = 2, ldy = 2;
    static int rdx = -3;
    static int rdy = 1;
    static int dx3 = 1;
    static int dy3 = -2;
    static int i = 1;
    static int di = 2;

    GR_SetDrawColor(w, SM_GetWindowColor(w,i));
    GR_DrawLine(w, lx, ly, rx, ry);
    GR_LineTo(w, x3, y3);
    GR_LineTo(w, lx, ly);
    lx = lx + ldx;
    ly = ly + ldy;
    rx = rx + rdx;
    ry = ry + rdy;
    x3 += dx3;
    y3 += dy3;
        if (lx <= 0) {
#ifdef __TURBOC__
            ldx = (random(2)+1);
#else
            ldx = (rand()%3 + 1);
#endif
        }
        if (lx >= GR_GetCanvasWidth(w)) {
#ifdef __TURBOC__
            ldx = -(random(2)+1);
#else
            ldx = -(rand()%3 + 1);
#endif
        }
        if (rx <= 0) {
#ifdef __TURBOC__
            rdx = (random(2)+1);
#else
            rdx = (rand()%3 + 1);
#endif
        }
        if (rx >= GR_GetCanvasWidth(w)) {
#ifdef __TURBOC__
            rdx = -(random(2)+1);
#else
            rdx = -(rand()%3 + 1);
#endif
        }
        if (ly <= 0) {
#ifdef __TURBOC__
            ldy = (random(2)+1);
#else
            ldy = (rand()%3 + 1);
#endif
        }
        if (ly >= GR_GetCanvasDepth(w)) {
#ifdef __TURBOC__
            ldy = -(random(2)+1);
#else
            ldy = -(rand()%3 + 1);
#endif
        }
        if (ry <= 0) {
#ifdef __TURBOC__
            rdy = (random(2)+1);
#else
            rdy = (rand()%3 + 1);
#endif
        }
        if (ry >= GR_GetCanvasDepth(w)) {
#ifdef __TURBOC__
            rdy = -(random(2)+1);
#else
            rdy = -(rand()%3 + 1);
#endif
        }
        if (x3 <= 0) {
#ifdef __TURBOC__
            dx3 = (random(2)+1);
#else
            dx3 = (rand()%3 + 1);
#endif
        }
        if (x3 >= GR_GetCanvasWidth(w)) {
#ifdef __TURBOC__
            dx3 = -(random(2)+1);
#else
            dx3 = -(rand()%3 + 1);
#endif
        }
        if (y3 <= 0) {
#ifdef __TURBOC__
            dy3 = (random(2)+1);
#else
            dy3 = (rand()%3 + 1);
#endif
        }
        if (y3 >= GR_GetCanvasDepth(w)) {
#ifdef __TURBOC__
            dy3 = -(random(2)+1);
#else
            dy3 = -(rand()%3 + 1);
#endif
        }
    i+= di;
    if ( i < 1) {
        i = 0;
#ifdef __TURBOC__
        di = random(2)+1;
#else
        di = rand()%3 + 1;
#endif
        
    }
    if (i >= SM_nWindowColors(w) - 2) {
        i = SM_nWindowColors(w) - 1;
#ifdef __TURBOC__
        di = -(random(2)+1);
#else
        di = -(rand()%3 + 1);
#endif
    }

}


int HowItWorks(WindowType *w)
{
    WindowType  *works;
    RectType    rt;
    TextboxType *tb;

    rt.Xmin = rt.Ymin = 150;
    rt.Xmax = rt.Xmin + 500;
    rt.Ymax = rt.Ymin + 350;
    works = SM_NewWindow(&rt, "Triserac.c", DOCUMENT | NOBACKING, NULL, NULL);
    rt.Xmin = rt.Ymin = 1;
    rt.Xmax = SM_GetContentWidth(works) - 2;
    rt.Ymax = SM_GetContentDepth(works) - 2;
    tb = SM_CreateTextbox(works,
                          &rt,
                          "triserac.c",
                          SM_GetSystemFont(),
                          True,
                          False,
                          NULL);
    SM_SetResizeProc(works, ResizeText);
    SM_SetUserData(works, (void *)tb);
    SM_OpenWindow(works);
}


int About(WindowType *w)
{
    WindowType  *about;
    RectType    rt;

    rt.Xmin = 50;
    rt.Ymin = 175;
    rt.Xmax = rt.Xmin + 400;
    rt.Ymax = rt.Ymin + 175;
    about = SM_NewWindow(&rt, "About Triserac", DIALOG | NOBACKING, NULL, NULL);
    rt.Xmin = 1;
    rt.Xmax = -999;
    rt.Ymin = -200;
    rt.Ymax = -275;
    SM_CreateLabel(about,&rt,"TRISERAC",NULL,ALIGNCENTER,False,False,False,NULL);
    rt.Ymin = rt.Ymax - 10;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "Geometric computer art and screen saver",
                   NULL, ALIGNCENTER, False, False, False, NULL);
    rt.Ymin = rt.Ymax - 175;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "Release:",
                   NULL, ALIGNCENTER, False, False, False, NULL);
    rt.Ymin = rt.Ymax - 10;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "4.0",
                   NULL, ALIGNCENTER, False, False, False, NULL);

    rt.Xmin = -400;
    rt.Xmax = -600;
    rt.Ymax = SM_GetContentDepth(about) - 10;
    rt.Ymin = rt.Ymax - 30;
    SM_CreateButton(about,
                    &rt,
                    "OK",
                    NULL,
                    CloseAbout);
    SM_OpenWindow(about);
}




int ResizeText(WindowType *w)
{
    TextboxType *tb;
    RectType    rt;

    tb = (TextboxType *)SM_GetUserData(w);
    rt.Xmin = rt.Ymin = 1;
    rt.Xmax = SM_GetContentWidth(w) - 2;
    rt.Ymax = SM_GetContentDepth(w) - 2;
    SM_SetTextboxRect(tb, &rt);
}

int CloseAbout(ButtonType *b)
{
    SM_CloseWindow(SM_GetGadgetWindow(b));
    return True;
}


