/*
** smtypes.h
**
** Mostly macro definitions and a few basic data structures for the TWS window
** manager.  Mostly used by intrinsic modules; applications only need to
** include the smwindow.h header, which includes this one too.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history: 
** 9 April 1992
** Original version (copied from previous source)
*/

#ifndef SMTYPES_H
#define SMTYPES_H

#define SMDEFAULT       0               /* Generic default definition       */

#define DOCUMENT        1               /* Window types                     */
#define DIALOG          2
#define SIMPLE          4
#define ICONONLY        8
#define PANEL           16

#define SCULPTED        1               /* Window decorations relief types  */
#define FOURD           2
#define FLAT            3
#define BEVELED         4
#define CHISELED        5

#define NOBACKING       0               /* Window content backing store?    */
#define BACKING         4
#define MENU            16
#define STATIC          8

#define CONTROLROOT     0               /* Control types                    */
#define BUTTON          1               
#define CHECKBOX        2
#define VSCROLLBAR      3
#define LABEL           4
#define EDITSTRING      5
#define PIXARRAY        7
#define HSCROLLBAR      8
#define PICKLIST        9
#define BOXTEXT         10
#define SLIDER          11
#define STRINGLIST      12
#define CHECKBOXGROUP   13
#define TEXTBOX         14
#define DRAGLABEL       15
#define SMSCROLLBAR     16
#define PIXMAP          17
#define ROTATELIST      18

#define VERTICAL        0               /* Slider types                     */
#define HORIZONTAL      1

#define APPTITLE            0
#define BORDERWIDTH         1           /* Window default keys              */
#define TITLEDEPTH          8
#define ACTIVETITLEBAR      9
#define ACTIVEBORDER        14
#define INACTIVETITLEBAR    11
#define INACTIVEBORDER      12
#define TITLEFONTCOLOR      13
#define COLORSCHEME         2
#define GRAPHDEVICE         4
#define MOUSEDEVICE         5
#define FONTPATH            3
#define SYSDEVICE           6
#define SYSTEMFONT          7
#define TEXTFONT            8
#define TITLEFONT           9
#define BEVELDEPTH          10
#define FOCUSCOLOR          11
#define TITLECOLOR          12
#define WINDOWLIMITS        13

#define UP                  1
#define DOWN                2
#define LEFT                3
#define RIGHT               4
#define UPLEFT              5
#define UPRIGHT             6
#define DOWNLEFT            7
#define DOWNRIGHT           8
#define MOVE_REGION         9
#define CLOSE_REGION        10
#define MENU_REGION         11
#define BASE_MENU_REGION    12
#define WINDOW_REGION       13
#define MAXIMIZE_REGION     14
#define CONTENT_REGION      15
#define WORKSPACE_REGION    16
#define DESKTOP             16
#define MINIMIZE_REGION     17
#define CANVAS_REGION       18
#define APP_TITLE_REGION    19

#define ALIGNLEFT           0           /* Text alignment constants         */
#define ALIGNCENTER         1
#define ALIGNRIGHT          2

#define ALIGNBASELINE       0
#define ALIGNBOTTOM         4
#define ALIGNMIDDLE         2
#define ALIGNTOP            3

#define TXTNORMAL           0           /* Text facing constants            */
#define TXTBOLD             1
#define TXTITALIC           2
#define TXTUNDERLINE        4
#define TXTSTRIKEOUT        8
#define TXTPROPORTIONAL   128

#define SAVE_UNDER_LIMIT    15000

#define CR      0x0d
#define ESC     27
#define BS      8


/*
** Pixel
*/
typedef struct {
    short X, Y;
} PointType;


typedef struct {
    short Xmin, Ymin, Xmax, Ymax;
} RectType;

/*
** Font record; for now just a pointer
*/
typedef struct {
    void    *fontbuf;
    char    *fontname;
} FontType;

/*
** Color type definition
*/
typedef struct {
    unsigned char r,g,b;                /* RGB value of this color          */
    int index;                          /* Lookup table index for the color */
    void *owner;                        /* Pointer to object that owns this colors */
    int flag;
    int count;
} ColorType;



/*
** Polygon header
*/
typedef struct {                        /* Polygon "header" structure       */
    unsigned short  polyBgn;            /* beginning index                  */
    unsigned short  polyEnd;            /* ending index                     */
    RectType        polyRect;           /* boundry limits                   */
} PolyHead;


/*
** A polygon
*/
typedef struct _poly {
    int         polycnt;
    PolyHead    polyhdr;
    PointType   polypts[7];
    int         pattern;
} PolygonType;


#define True    1
#define False   0

#endif
