/*
** smtext.h
**
** Header for text display gadget.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**                                
** Revision history:
**
** Tue  08-04-1992
** Original version
*/

#ifndef SMTEXT_H
#define SMTEXT_H

#define TWSTEXTSIZE     32760

#include "smslider.h"
#include "smgadget.h"


typedef struct _tlisttype {
    char                *buf;
    char                **line;
} TextlistType;

typedef struct _textboxtype {
	GadgetType	*gadget;				/* 'Superclass' gadget				*/
    FontType    *font;                  /* Display font                     */
    char        *filename;              /* Filename                         */
    TextlistType *list;                 /* String list                      */
    int         nlines;                 /* Number of text lines that fit    */
    int         tlines;                 /* Total number of lines            */
    int         border;                 /* Box border flag                  */
    int         topline;                /* Points at top line in box        */
    int         bottomline;             /* Points at last line in box       */
    int         wordwrap;               /* If TRUE then wrap lines          */
	SliderType  *vslider;               /* Slider, if necessary             */
} TextboxType;


/*
** Function prototypes
*/

TextboxType *SM_CreateTextbox(WindowType *w,
                              RectType *r,
                              char *filename,
                              FontType *font,
                              int border,
                              int wrap,
                              int (*f)());
void         SM_SetTextboxRect(TextboxType *tb, RectType *r);
int          SM_TextboxLineDown(TextboxType *tb);
int          SM_TextboxLineUp(TextboxType *tb);
int          SM_TextboxPageDown(TextboxType *tb);
int          SM_TextboxPageUp(TextboxType *tb);

int          DestroyTextbox(GadgetType *c);
int          DrawTextbox(GadgetType *g);
int          TextboxFunc(GadgetType *tb);
int          TextScroll(SliderType *sl);






#endif
