/*
** smstrlst.h
**
** Public header file for the stringlist control.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Thu  04-09-1992
*/

#ifndef SMSTRLST_H
#define SMSTRLST_H

/*
** Include the global definitions
*/

/*
#include "smtypes.h"
#include "smwindow.h"
*/

#include "smgadget.h"                   /* Window control definitions       */
#include "smslider.h"

/*
** Stringlist structure definition
*/
typedef struct _sl {
	GadgetType	*gadget;				/* 'Superclass' gadget				*/
	int         nstart;                 /* first string to display      	*/
    int         ndisplay;               /* Number of strings to display 	*/
    int         nselected;              /* Index of selected string     	*/
    int         nitems;                 /* Total number of list items   	*/
	char        **list;                 /* String list                  	*/
    int         destroyflag;            /* If true gadget can free stringlist*/
    int         scrollflag;             /* If true gadget can free stringlist*/
    int         allowmulti;             /* If true then allow multiple selections */
    int         ncolumns;               /* Number of columns in list        */
    char        **cols[10];             /* Pointers to column heads         */
    int         firstcol;               /* Leftmost column index            */
    int         columnsep;              /* Pixel separation between cols    */
    int         colfit;                 /* Number of displayable columns    */
    SliderType  *hscrollbar;            /* Stringlist scroll, if requested  */
    SliderType  *vscrollbar;            /* Stringlist scroll, if requested  */
    void        *data;                  /* User data pointer                */
} StringlistType;


/*
** Function prototypes
*/
StringlistType *SM_CreateStringlist(
    WindowType  *w,
    RectType    *r,
    char        **list,
    int         nitems,
    int         nstart,
    int         ncols,
    int         (*f)(),
    int         destroyflag,
    int         scrollflag,
    int         multiflag,
    void        *data);
int     SM_GetStringlistNdisplay(StringlistType *sl);
int     SM_GetStringlistSelection(StringlistType *sl);
char   *SM_GetStringlistSelectString(StringlistType *sl);
int     SM_RedrawStringlist(StringlistType *s);
void    SM_SetStringlistList(StringlistType *stringlist, char **list, int nitems);
void    SM_SetStringlistSelection(StringlistType *sl, int n);


#endif
