/*
** smslider.h
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Public header for slider control.
*/

#ifndef SMSLIDER_H
#define SMSLIDER_H

/*
#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
*/

#include "smgadget.h"                   /* Window control definitions       */

#define SLIDERTHUMBSTATE    1           /* Slider thumb states              */
#define SLIDERTHUMBDONESTATE 4
#define SLIDERJUMPUPSTATE   2
#define SLIDERJUMPDOWNSTATE 3
#define SLIDERDONESTATE     0

/*
** slider structure definition
*/
typedef struct _sli {
    GadgetType *gadget;                 /* 'Superclass' gadget              */
	RectType thumbbar;                  /* Slide thumbbar region            */
    int     type;                       /* Horizontal or Vertical           */
    int     min;                        /* Slider value at minimum          */
	int     max;                        /* Slider value at maximum          */
    int     scale;                      /* Size of jump in user units       */
    int     position;                   /* min <= position <= max           */
	int     twidth;                     /* Width in pixels of thumbbar      */
    int     pixels;                     /* Number of pixels free movement   */
    int     state;
    double  inc;                        /* Units/pixel for thumbbar moves   */
    void    *data;                      /* User-specified data for button   */
} SliderType;


/*
** Function prototypes
*/
SliderType *SM_CreateSlider(
    WindowType  *w,                     /* Parent window                    */
    RectType    *box,                   /* Outline of channel               */
    int         type,                   /* Horizontal or vertical           */
    int         min,                    /* Value at slider min              */
    int         max,                    /* Value at slider max              */
    int         size,                   /* Number of objects for thumbbar   */
    int         initpos,                /* Initial value                    */
    void        *data,                  /* User data                        */
    int         (*function)());         /* Function when slider changes     */
int         SM_DestroySlider(SliderType *s);
void       *SM_GetSliderData(SliderType *s);
int         SM_GetSliderPosition(SliderType *s);
int         SM_GetSliderMin(SliderType *s);
int         SM_GetSliderMax(SliderType *s);
int         SM_SetSliderChannel(SliderType *slider, RectType *box);
int         SM_SetSliderData(SliderType *sl, void *data);
int         SM_SetSliderMinMax(SliderType *s, int min, int max);
int         SM_SetSliderScale(SliderType *s, int scale);
void        SetSliderThumb(SliderType *slider);
void        SM_SetSliderPosition(SliderType *sl, int position);
#endif
