/*
** smscroll.h
**
** Header file for scrollbar gadget.
**
**
** Copyright 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
** All rights reserved
**
** Revision history:
**
** 15 June 93
** Original version
*/

#ifndef SMSCROLL_H
#define SMSCROLL_H

#include "smtypes.h"
#include "smwindow.h"
#include "smgadget.h"                   /* Generic gadget definitions       */
#include "smslider.h"                   /* Subclass a slider gadget         */
#include "smbutton.h"


#define SCROLLBARUP     1
#define SCROLLBARDOWN   2

typedef struct _sb {
    GadgetType  *gadget;
    void        *data;
    int         type;
    SliderType  *slider;
    ButtonType  *upbutton;
    ButtonType  *downbutton;
} ScrollbarType;


/*
** Function prototypes
*/
ScrollbarType *SM_CreateScrollbar(
    WindowType  *w,                     /* Parent window                    */
    RectType    *box,                   /* Outline of scrollbar             */
    int         type,                   /* Horizontal or vertical           */
    int         min,                    /* Value at slider min              */
    int         max,                    /* Value at slider max              */
    int         size,                   /* Number of objects for thumbbar   */
    int         initpos,                /* Initial value                    */
    void        *data,                  /* User data                        */
    int         (*slifunc)());          /* Function when slider changes     */

void   *SM_GetScrollbarData(ScrollbarType *s);
int     SM_GetScrollbarMax(ScrollbarType *s);
int     SM_GetScrollbarMin(ScrollbarType *s);
int     SM_GetScrollbarPosition(ScrollbarType *s);
int     SM_GetScrollbarScale(ScrollbarType *s);
void    SM_SetScrollbarData(ScrollbarType *s, void *data);
void    SM_SetScrollbarMinMax(ScrollbarType *s, int min, int max);
void    SM_SetScrollbarPosition(ScrollbarType *s, int p);
void    SM_SetScrollbarScale(ScrollbarType *s, int scale);


#endif


