/*
** smpixmap.h
**
** User header file for pixmaps
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 21 April 93
** Original version:
*/

#ifndef SMPIXMAP_H
#define SMPIXMAP_H


#define SMPIXMAPLIMIT   16384           /* Max size of pixmap image         */
#define SMPIXMAPID      101010L         /* File identifier for pixmap image */
#define SMPMNOFILE      1               /* Unable to open pixmap file       */
#define SMPMBADTYPE     2               /* File is not pixmap file type     */

#include "smtypes.h"
#include "smwindow.h"
#include "smgadget.h"

/*
** Type definitions
*/

typedef struct {
    GadgetType  *gadget;                /* Superclass gadget                */
    int         *pixmap;                /* Array of color indices           */
    void        *piximage;              /* Screen image                     */
    int         redraw;                 /* If True then pixmap was modified */
    int         border;                 /* If True draw border around pixmap*/
    int         blocking;               /* If True then don't save image    */
                                        /*     after every pixel change     */
} PixmapType;

/*
** Function prototypes
*/

PixmapType *SM_CreatePixmap(WindowType *w, RectType *bound, int border);
int         SM_GetPixmapBlocking(PixmapType *pm);
void        SM_SetPixmapBlocking(PixmapType *pm, int blocking);
void        SM_SetPixmapPixel(PixmapType *pm, int x, int y, ColorType *c);
int         SM_DestroyPixmap(PixmapType *pm);
ColorType  *SM_GetPixmapPixel(PixmapType *pm, int x, int y, ColorType *c);
void        SM_MovePixmap(PixmapType *pm, int dx, int dy);
PixmapType *SM_ReadPixmap(char *fname);
int         SM_GetPixmapWidth(PixmapType *pm);
int         SM_GetPixmapDepth(PixmapType *pm);
int         SM_WritePixmap(PixmapType *pm, char *fname);
int         DrawPixmap(GadgetType *g);
void        SM_CopyPixmap(PixmapType *dest, PixmapType *source);

#endif




