/*
** picklist.h
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Header for the picklist window; return an item from a list of strings
*/

#ifndef PICKLIST_H
#define PICKLIST_H

/*
#include "smwindow.h"
*/
#include "smslider.h"
#include "smstrlst.h"
#include "smbutton.h"
#include "smlabel.h"

/*
** Picklist type definition
*/
typedef struct _plist {
    char            *title;
    WindowType      *pickwin;           /* This control                     */
    SliderType      *slider;            /* Scroll control                   */
    LabelType       *selectstring;      /* Display for selected string      */
    StringlistType  *slist;             /* List to pick from                */
    ButtonType      *ok;                /* Accept select value              */
    ButtonType      *cancel;            /* Exit without returning selection */
    int             nselected;          /* Index of string selected         */
    char            *string;            /* Pointer to string selected       */
} PicklistType;


/*
** Function prototypes
*/
int SM_Picklist(
    char    *title,
    RectType *pbox,                     /* Box strings should fit into      */
    char    *list[],                    /* Strings for list                 */
    int     nitems,                     /* Total number of strings in list  */
    int     nstart,                     /* Index for first string to list   */
    int     selected,                   /* Index of selected string         */
    int     destroyflag
    );

#endif
