

#ifndef MEM_H
#define MEM_H

/*
#include    "toolkit.h"
*/

/*
** Define machine-specific features
*/
#ifdef __WATCOMC__
#define PROTOTYPING     1
#define HOSTBYTESWAPPED 0
#define EXIT_SUCCESS    0
#endif
#ifdef __TURBOC__
#define EXIT_FAILURE    1
#define PROTOTYPING     1
#define HOSTBYTESWAPPED 0
#define EXIT_SUCCESS    0
#endif

#define BITSPERBYTE     8
#define SIZEOFINT       sizeof(int)
#define SIZEOFLONG      sizeof(long)

#ifndef STATIC
#define STATIC static
#endif

#define ARRAYSIZE(array)    (sizeof(array) / sizeof(array[0]))

/*
** Prototyping macros
*/

#if PROTOTYPING
#ifdef MSC
#define _0
#else
#define _0                                  void
#endif
#define _1(v)                               v
#define _2(v1,v2)                           v1,v2
#define _3(v1,v2,v3)                        v1,v2,v3
#define _4(v1,v2,v3,v4)                     v1,v2,v3,v4
#define _5(v1,v2,v3,v4,v5)                  v1,v2,v3,v4,v5
#define _6(v1,v2,v3,v4,v5,v6)               v1,v2,v3,v4,v5,v6
#define _7(v1,v2,v3,v4,v5,v6,v7)            v1,v2,v3,v4,v5,v6,v7
#define _8(v1,v2,v3,v4,v5,v6,v7,v8)         v1,v2,v3,v4,v5,v6,v7,v8
#define _9(v1,v2,v3,v4,v5,v6,v7,v8,v9)      v1,v2,v3,v4,v5,v6,v7,v8,v9
#define _10(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10) v1,v2,v3,v4,v5,v6,v7,v8,v9,v10

#else

#define _0
#define _1(v)
#define _2(v1,v2)
#define _3(v1,v2,v3)
#define _4(v1,v2,v3,v4)
#define _5(v1,v2,v3,v4,v5)
#define _6(v1,v2,v3,v4,v5,v6)
#define _7(v1,v2,v3,v4,v5,v6,v7)
#define _8(v1,v2,v3,v4,v5,v6,v7,v8)
#define _9(v1,v2,v3,v4,v5,v6,v7,v8,v9)
#define _10(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)

#endif

#if PROTOTYPING
#define P(s)    s
#else
#define P(s)    ()
#endif

#ifdef DEBUG
#define debug(a)    (a)
#else
#define debug(a)
#endif


/*
** Memory management routines
**
** #define MEM_DEBUG 1  when compiling to enable extended debugging features.
**
** Features always enabled:
**
**  *   mem_init() is called at startup, and mem_term() is called at close,
**      which checks to see that number of allocs is same as number of frees.
**  *   Behavior on out-of-memory conditions can be controlled via
**      mem_setexception().
**
** Extended debugging features:
**
**  *   Check values inserted before and after data to detect pointer overruns
**      and underruns.
**  *   Free'd pointers are checked against alloc'd pointers.
**  *   Free'd storage cleared to detect references to free'd data.
**  *   Realloc'd pointers are always changed, and previous storage is
**      cleared to detect errorneous references to realloced data.
**  *   mem_checkptr() checks an alloc'd pointer.
*/

/*
** Global variables
*/
extern int mem_inited;                  /* non-zero if mem stuff initialized*/

/*
** Public functions
*/
/*
** Define behaviors when mem can't allocate memory
*/
typedef int (*intfp)();

#ifdef __TURBOC__
enum MEM_E  {MEM_ABORTMSG, MEM_ABORT, MEM_RETNULL, MEM_CALLFP, MEM_RETRY};
void mem_setexception(_2(enum MEM_E,intfp));
#else
#define MEM_ABORTMSG    0
#define MEM_ABORT       1
#define MEM_RETNULL     2
#define MEM_CALLFP      3
#define MEM_RETRY       4
void mem_setexception(_2(int,intfp));
#endif

char *mem_strdup(_1(const char *));
void mem_freefp(_1(void *p));
void mem_check(_0);
void mem_checkptr(_1(void *));
void *mem_malloc(_1(unsigned));
void *mem_calloc(_1(unsigned));
void *mem_realloc(_2(void *, unsigned));
void mem_free(_1(void *));
void mem_init(_0);
int mem_term(_0);

#ifdef MEM_DEBUG
#define mem_strdup(p)   mem_strdup_debug((p), __FILE__, __LINE__)
#define mem_malloc(u)   mem_malloc_debug((u), __FILE__, __LINE__)
#define mem_calloc(u)   mem_calloc_debug((u), __FILE__, __LINE__)
#define mem_realloc(p,u)   mem_realloc_debug((p), (u), __FILE__, __LINE__)
#define mem_free(p)     mem_free_debug((p), __FILE__, __LINE__)

#if PROTOTYPING
extern char *mem_strdup_debug(const char *, char *, int);
extern void *mem_calloc_debug(unsigned, char *, int);
extern void *mem_malloc_debug(unsigned, char *, int);
extern void *mem_realloc_debug(void *, unsigned, char *, int);
extern void mem_free_debug(void *, char *, int);
extern void mem_freefp(void *);
#else
extern char *mem_strdup_debug();
extern void *mem_calloc_debug();
extern void *mem_malloc_debug();
extern void *mem_realloc_debug();
extern void mem_free_debug();
extern void mem_freefp();
#endif

void mem_setnewfileline(_3(void *, char *, int));

#else
#define mem_freefp      mem_free
#define mem_check()
#define mem_checkptr(p)

#endif  /* MEM_DEBUG */

#endif  /* MEM_H */


