/*
** smstring.h
**
** Public header file for window string gadget.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Thu  04-09-1992:
** Original version
*/

#ifndef SMLABEL_H
#define SMLABEL_H

/*
** Dependency definitions
*/

/*
#include "smtypes.h"
#include "smwindow.h"
*/


#include "smgadget.h"

/*
** type definition
*/
typedef struct _lbl {
    GadgetType *gadget;					/* This gadget's parent				*/
    int     boldflg;                    /* TRUE if string is bolded         */
    int     italflg;                    /* TRUE if string is italicized     */
    int     boxflg;                     /* TRUE if string is boxed          */
	char    *string;                    /* The text to be displayed         */
    int     align;                      /* Left, right or centered          */
    void    *data;                      /* User data field                  */
    int     (*graphproc)(struct _lbl *);/* Graphic label function           */
    int     sculptype;                  /* Type of label decoration         */
} LabelType;


/*
** Function prototypes
*/
int         SM_SetLabelString(LabelType *tx, char *string);
LabelType  *SM_CreateLabel(WindowType *w,
                           RectType *box,
                           char    *str,
                           int     (*labelproc)(),
                           int     align,
                           int     boldflg,
                           int     italflg,
                           int     boxflg,
                           void    *data);
void        SM_DestroyLabel(LabelType *l);
int         SM_EraseLabel(LabelType *text);
GadgetType *SM_GetLabelGadget(LabelType *s);
int         SM_GetLabelBoldflag(LabelType *s);
int         SM_GetLabelBoxflag(LabelType *s);
void       *SM_GetLabelData(LabelType *label);
int         SM_GetLabelItalflag(LabelType *s);
char       *SM_GetLabelString(LabelType *s);
int         SM_SetLabelBoldflag(LabelType *s, int flag);
int         SM_SetLabelBoxflag(LabelType *s, int flag);
void        SM_SetLabelData(LabelType *label, void *data);
void        SM_SetLabelGraphProc(LabelType *label, int (*f)());
int         SM_SetLabelItalflag(LabelType *s, int flag);
void        SM_SetLabelSculptType(LabelType *label, int stype);
int         SM_SetLabelString(LabelType *tx, char *string);


#endif

