/*
** sminit.h
**
** Header for window system intialization, reading user preferences from disk
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Sat  07-11-1992
** Original version
*/

#ifndef SMINIT_H
#define SMINIT_H

typedef struct _inittable {
    char    *apptitle;
    int     borderwidth;
    int     colorscheme;
    char    *fontpath;
    char    *graphdevice;
    char    *mousedevice;
    char    *sysdevice;
    char    *systemfont;
    char    *textfont;
    char    *titlefont;
    int     focuscolor[3];
    int     titlecolor[3];
    int     limitwindows;
    long    fields;
} InitTable;

/*
** Define the field flags
*/
#define twsINITAPPTITLE     1
#define twsINITBORDERWIDTH  (1 << 1)
#define twsINITCOLORSCHEME  (1 << 2)
#define twsINITFONTPATH     (1 << 3)
#define twsINITGRAPHDEVICE  (1 << 4)
#define twsINITMOUSEDEVICE  (1 << 5)
#define twsINITSYSDEVICE    (1 << 6)
#define twsINITSYSTEMFONT   (1 << 7)
#define twsINITTEXTFONT     (1 << 8)
#define twsINITTITLEFONT    (1 << 9)
#define twsINITBEVELDEPTH   (1 << 10)
#define twsINITFOCUSCOLOR   (1 << 11)
#define twsINITTITLECOLOR   (1 << 12)
#define twsINITWINLIMITS    (1 << 13)

#define COMMENT_SYMBOL  '#'

int SM_ReadConfig(void);


#endif
