/*
** SMgraph.h
**
** Header file for drawing functions within windows.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 30 March 1992:
** Original
** Provides some basic drawing functions, all of which are window-relative.
** The initial functions are:
**
*/

#ifndef SMGRAPH_H
#define SMGRAPH_H

/*
** Include basic system types
*/

#include "smtypes.h"
#include "smwindow.h"

#include <metawndo.h>


#define GRNOBORDER      0
#define GRLINEBORDER    3
#define GRRAISEDBORDER  4
#define GRRECESSBORDER  1

#define SMREP           0
#define SMOR            1
#define SMXOR           2
#define SMNAND          3
#define SMNREP          4
#define SMNOR           5
#define SMNXOR          6
#define SMAND           7

#define SMOUTLINE       0               /* Closed geometry fill types       */
#define SMFILLED        1
#define SMSOLID         2

#define GRWIDTHNORM     1               /* Line width settings              */
#define GRWIDTHWIDE     3

#define GRNORMAL        0
#define GRDASHLINE      2
#define GRDOTLINE       4

typedef image   ImageType;

#define GRMAXIMAGE      65518L

/*
** Function prototypes
*/
int             GR_CharWidth(char c);
int             GR_ClearCanvas(WindowType *w);
int             GR_CloseGraphState(WindowType *w);
GraphStateType *GR_CreateGraphState(WindowType *w,RectType *r,int Border);
int             GR_DrawArray(WindowType *w, int x, int y, int length, ColorType **array);
int             GR_DrawArrayI(int x, int y, int length, ColorType **array);
int             GR_DrawCircle(WindowType *w, int x, int y, int r);
int             GR_DrawCircleI(int x, int y, int r);
int             GR_DrawFilledCircle(WindowType *w, int x, int y, int r);
int             GR_DrawFilledPolygon(WindowType *w, int npts, int *pts);
int             GR_DrawFilledRect(WindowType *w, RectType *r);
int             GR_DrawLine(WindowType *w, int x1, int y1, int x2, int y2);
int             GR_DrawLineI(int x1, int y1, int x2, int y2);
int             GR_DrawPoint(WindowType *w, int x, int y);
int             GR_DrawPointI(int x, int y);
int             GR_DrawPolygon(WindowType *w, int npts, int *pts);
int             GR_DrawRect(WindowType *w, RectType *r);
int             GR_DrawSolidCircle(WindowType *w, int x, int y, int r);
int             GR_DrawSolidPolygon(WindowType *w, int npts, int *pts);
int             GR_DrawSolidRect(WindowType *w, RectType *r);
int             GR_DrawString(WindowType *w, int x, int y, char *string);
int             GR_DrawStringI(int x, int y, char *string);
ColorType      *GR_GetBackgroundColor(WindowType *w);
int             GR_GetCanvasDepth(WindowType *w);
RectType       *GR_GetCanvasRect(WindowType *w);
int             GR_GetCanvasWidth(WindowType *w);
int             GR_GetCursor(WindowType *w, int *x, int *y);
int             GR_GetDevicePoint(int x, int y, ColorType *c);
ColorType      *GR_GetDrawColor(WindowType *w);
void            GR_GetGraphicsLocator(WindowType *w, int *x, int *y);
int             GR_GetMouse(WindowType *w, int *state, int *x, int *y);
ColorType      *GR_GetPalette(WindowType *w);
int             GR_GetPoint(WindowType *w, int x, int y, ColorType *c);
int             GR_GetPointI(int x, int y, ColorType *c);
int             GR_GetTextLocator(WindowType *w, int *x, int *y);
void            GR_HideCursor(void);
void            GR_InsetRect(RectType *r, int dx, int dy);
int             GR_IsBlocked(void);
int             GR_LineTo(WindowType *w, int x, int y);
int             GR_LineToI(int x, int y);
int             GR_MouseInCanvas(WindowType *w);
void            GR_MoveTo(WindowType *w, int x, int y);
void            GR_MoveToI(int x, int y);
int             GR_nColorBits(void);
void            GR_OffsetRect(RectType *r, int dx, int dy);
int             GR_PointInRect(int x, int y, RectType *r);
void            GR_ProtectCanvas(WindowType *w);
void            GR_ProtectOff(WindowType *w);
int             GR_SetBackground(WindowType *w, ColorType *c);
int             GR_SetBackgroundColor(WindowType *w, ColorType *c);
int             GR_SetBackgroundI(ColorType *color);
int             GR_SetBlocking(WindowType *w);
void            GR_SetCanvasRect(WindowType *w, RectType *r);
void            GR_SetDrawColor(WindowType *w, ColorType *c);
void            GR_SetDrawColorI(ColorType *color);
void            GR_SetDrawMode(WindowType *w, int mode);
void            GR_SetDrawModeI(int mode);
void            GR_SetFont(FontType *f);
void            GR_SetLineWidth(WindowType *w, int width);
void            GR_SetPalette(WindowType *w, ColorType *pal, int ncolors);
void            GR_SetRect(RectType *r, int x1, int y1, int x2, int y2);
void            GR_SetTextMode(WindowType *w, int mode);
void            GR_SetTextModeI(int mode);
void            GR_ShiftPolygon(int npts, int *pts, int dx, int dy);
void            GR_ShiftRect(RectType *r, int dx, int dy);
void            GR_ShowCursor(void);
int             GR_StringWidth(char *s);
int             GR_TextWidth(char *s, int start, int length);
void            GR_UnlimitMouse(void);
void            GR_UnsetBlocking(void);
void            GR_SetLineStyle(WindowType *w, int style);
int             GR_PutImage(WindowType *w, RectType *r, ImageType *twsimage);
int             GR_GetImage(WindowType *w, RectType *r, ImageType *twsimage);
unsigned long   GR_ImageSize(RectType *rect);

#endif
