/*
** smgadget.h
**
** Public header for the window gadget list manager
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/       

#ifndef SMGADGET_H
#define SMGADGET_H

/*
** The foundation gadget class
*/
typedef struct _gadget {
	void        *gadget;				/* Specific gadget fields struct	*/
    WindowType  *parentwin;				/* Window containing the gadget		*/
    RectType    bound;					/* Sensitive region for the gadget	*/
    int         type;					/* Type of gadget subclassed		*/
    int         msg;					/* Event types gadget responds to	*/
    int         nofree;                 /* If True gadget not freed on close*/
    int         redraw;                 /* If True gadget needs redrawing   */
    int         (*drawproc)(struct _gadget *);      /* Draw the gadget      */
    int         (*deleteproc)(struct _gadget *);    /* Delete gadget        */
    int         (*shellproc)(struct _gadget *,EventType *);
    int         (*userproc)(void *);    /* Gadget user procedure            */
    struct _gadget *next, *prev;		/* Links							*/
} GadgetType;

/*
** A 'generic' gadget that any window gadget can be cast to to
** retrieve the gadget class
*/
typedef struct {
    GadgetType  *gadget;
} AnyGadgetType;


/*
** Function prototypes
*/
GadgetType *SM_AddGadget(WindowType *w,      /* Parent window               */
                         int type,           /* Kind of control             */
                         void *gadget,       /* Pointer to specific gadget  */
                         unsigned msg,       /* Messages the gadget respo   */
                         RectType *r,        /* Gadget boundary             */
                         int (*draw)(),      /* Gadget's draw procedure     */
                         int (*deleteproc)(),/* Gadget deallocation         */
                         int (*shellproc)(), /* Gadget shell procedure      */
                         int (*proc)());     /* Gadget's user function      */

int         SM_AttachGadget(WindowType *w, GadgetType *newgadget);
int         SM_CloseGadgets(GadgetType *g);
int         SM_DestroyGadget(GadgetType *g);
WindowType *SM_GadgetToWindow(void *gadget);
RectType   *SM_GetGadgetBound(void *g);
WindowType *SM_GetGadgetWindow(void *g);
int         SM_GetGadgetType(GadgetType *g);
void       *SM_GetGadgetGadget(GadgetType *g);
int         SM_GetGadgetMsg(GadgetType *g);
GadgetType *InitGadget(WindowType *w);
int         SM_RefreshGadgets(WindowType *w);
int         SM_SetGadgetBound(GadgetType *g, RectType *r);
int         SM_SetGadgetMsg(GadgetType *g, int msg);
int         SM_SetGadgetDrawproc(GadgetType *g, int (*f)());
int         SM_SetGadgetDeleteproc(GadgetType *g, int (*f)());
void        SM_SetGadgetRedrawFlag(void *g, int flg);
int         SM_SetGadgetUserproc(GadgetType *g, int (*f)());



#endif


