/*
** smeventp.h
**
** Private header for event handler
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 19 May 1992
** Original version
**
** Tue  2 Jun 92    Dean Clark
** Removed the Metawindow-specific 'event' field from the SM EventType
** structure.  Replaced with individual fields that are essentially the same
** but not dependent on metawindow lib.
*/


#ifndef SMEVENTP_H
#define SMEVENTP_H

/*
** Event record
*/
typedef struct _smevent {
    int     region;                     /* Window region where event occured*/
    unsigned int event_type;            /* Kind of event                    */
    char    ASCII;                      /* ASCII code for keyboard event    */
    char    ScanCode;                   /* Scan code for special key        */
    int     State;                      /* Keyboard states                  */
    int     Buttons;                    /* Button state                     */
    unsigned char Type;                 /* Event type                       */
    int     manage_event;               /* Window management event          */
    int     CursorX, CursorY;           /* Cursor position when event occurd*/
    int     Time;                       /* Time tick when event occured     */
    long    localtime;                  /* Time of day when event occured   */
} EventType;

#endif

