/*
** smcolor.h
**
** Public header file for color manager
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Fri  06-05-1992
** Original version
*/

#ifndef SMCOLOR_H
#define SMCOLOR_H

/*
#include "smtypes.h"
#include "smwindow.h"
*/

/*
** Macros for accessing window system colors
*/
#define SMCLOSESTCOLOR      0x0004
#define SMNOSHARE           0x0002
#define SMSHARE             0x0001
#define SMFLAGDEFAULT       SMSHARE
#define TEXT_COLOR          SMWHITE     /* System color index constants     */
#define UP_BEVEL_COLOR      SMLIGHTRB
#define DN_BEVEL_COLOR      SMBLACK
#define INACTIVE_UP_BEVEL   UP_BEVEL_COLOR
#define INACTIVE_DN_BEVEL   DN_BEVEL_COLOR
#define ACTIVE_WIN_COLOR    SMDARKRB
#define INACTIVE_WIN_COLOR  SMLIGHTGRAY
#define ACTIVE_UP_BEVEL     SMLIGHTRB
#define ACTIVE_DN_BEVEL     SMBLACK
#define DESKTOP_COLOR       SMLIGHTGRAY
#define TITLE_TEXT_COLOR    SMLIGHTYG
#define BUTTON_FACE_COLOR   SMLIGHTGRAY
#define BUTTON_UP_BEVEL     SMWHITE
#define BUTTON_DOWN_BEVEL   SMDARKGRAY
#define BUTTON_TEXT_COLOR   SMBLACK
#define GADGET_FACE_COLOR   BUTTON_FACE_COLOR
#define GADGET_UP_BEVEL     BUTTON_UP_BEVEL
#define GADGET_DOWN_BEVEL   BUTTON_DOWN_BEVEL
#define GADGET_TEXT_COLOR   BUTTON_TEXT_COLOR
#define SMBLACK             0
#define SMDARKGRAY          1
#define SMLIGHTGRAY         2
#define SMMEDIUMGRAY        5
#define SMDARKRB            3
#define SMLIGHTRB           4
#define SMDARKYG            5
#define SMLIGHTYG           6
#define SMWHITE             256

#define SMWARM              1
#define SMCOOL              2

/*
** Function prototypes
*/
long        SM_ActivatePalette(WindowType *w);
ColorType  *SM_CreateColor(int r, int g, int b);
ColorType  *SM_CreateWindowPalette(WindowType *w, int ncolors);
ColorType  *SM_GetClosestColor(WindowType *w, int r, int g, int b);
ColorType  *smGetClosestSystemColor(ColorType *c);
ColorType  *SM_GetPalette(WindowType *w);
ColorType  *SM_GetSystemColor(int i);
ColorType  *SM_GetWindowColor(WindowType *w, int n);
void        SM_InitColor(int r, int g, int b, ColorType *c);
long        SM_InitSystemColors(long ncolors);
int         SM_IsColorEqual(ColorType *c1, ColorType *c2);
int         SM_ModifyWindowColor(WindowType *w, int n, int r, int g, int b);
int         SM_nApplicationColors(void);
long        SM_nSystemColors(void);
int         SM_nColorBits(void);
int         SM_nWindowColors(WindowType *w);
int         SM_SetSystemColor(int n, int r, int g, int b);
ColorType  *SM_SetWindowColor(WindowType *w, int i, int r, int g, int b, int flag);
void        SM_ModifySystemColor(int i, int r, int g, int b);

void        CloseSystemColors(void);


#endif



