/*
** smchkbx.h
**
** Header file for API routines for the checkbox control type.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#ifndef SMCHKBX_H
#define SMCHKBX_H

#include "smgadget.h"

#define     SMCBOXSQUARE  0
#define     SMCBOXBUTTON  1
#define     SMCBOXOVAL    2

/*
** Type definitions
*/

/*
** The Checkbox
**
** This is usually a depressed/undepressed small box.  Often the
** interior is shaded differently when the box is depressed.  Usually the
** box sits next to a short text descriptor or perhaps an icon.
*/
typedef struct _cb {
    GadgetType	*gadget;				/* Superclass gadget				*/
	char        *label;
    int         type;                   /* Visual type                      */
    int         buttonpos;              /* Position for label              	*/
    int         selected;               /* TRUE if button checked           */
	void        *data;                  /* User-specified data for button   */
    void        *group;                 /* Is this checkbox in a group?     */
} CheckboxType;



/*
** CheckboxGroup
**
** A collection of checkboxes. Only one of the group can be active at a time
*/
typedef struct _group {
    GadgetType		*gadget;			/* Superclass						*/
	CheckboxType    *selected;          /* Active checkbox                  */
    int             selfadjust;         /* If true group boundary autoadjust*/
    int             outline;            /* If true group bounds is drawn    */
    char            *title;             /* Group title                      */
} CheckboxGroupType;


/*
** Function prototypes
*/
CheckboxType *SM_AddCheckbox(
    CheckboxGroupType   *group,         /* Checkbox group to add to         */
    RectType            *box,           /* Boundary RectType for checkbox   */
    char                *label,         /* Text label                       */
    int                 buttonpos,      /* LEFT or RIGHT for text           */
    int                 selected,       /* TRUE if this checkbox is on      */
    void                *data,          /* User data                        */
	int                 (*action)());   /* Function called when selected    */

CheckboxType *SM_CreateCheckbox(
    WindowType  *w,
    RectType *box,
    char    *label,                     /* Checkbox label                   */
    int     buttonpos,                  /* To left or right of cbox         */
    int     selected,                   /* TRUE if checkbox is "on"         */
    void    *data,                      /* User data                        */
	int     (*action)());               /* Function called when cbox selected*/

CheckboxGroupType *SM_CreateCheckboxGroup(
    WindowType  *w,                     /* Parent window                    */
    RectType    *r,                     /* Group boundary                   */
    char        *label,                 /* Group title                      */
    int         draw,                   /* Draw boundary, title if True     */
    int         (*action)());           /* Group user proc                  */

int     SM_DestroyCheckbox(CheckboxType *c);
int     SM_DestroyCheckboxGroup(CheckboxGroupType *c);
int     SM_GetCheckboxState(CheckboxType *c);
int     SM_GetCheckboxType(CheckboxType *c);
int     SM_SetCheckboxLabel(CheckboxType *c, char *d);
int     SM_SetCheckboxProc(CheckboxType *c, int (*f)());
int     SM_SetCheckboxSelected(CheckboxType *cb);
int     SM_SetCheckboxState(CheckboxType *c, int selected);
void    SM_SetCheckboxType(CheckboxType *c, int type);


#endif
