/*
** wintest6.c
**
** Test 6 of the SM window system.
** Test the button gadget.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Mon  06-29-1992
** Original version
*/

#include <stdio.h>

#include "smwindow.h"
#include "smevent.h"
#include "smbutton.h"
#include "smcolor.h"
#include "smgraph.h"

extern FILE *ferr;

int ButtonUserproc(ButtonType *b);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    ButtonType  *b1, *b2;
    RectType    r;

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Button Gadget", NULL); /* Create application screen    */

    /*
    ** Create and open an application window
    */
    r.Xmin = r.Ymin = 180;
    r.Xmax = r.Ymax = 400;
    w = SM_NewWindow(&r, "Test Window", DOCUMENT | NOBACKING, NULL, NULL);

    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Add a button before the window is opened
    */
    r.Xmin = r.Ymin = 10;
    r.Xmax = r.Xmin + GR_StringWidth("  Button 1  ");
    r.Ymax = r.Ymin + 24;
    b1 = SM_CreateButton(w,
                         &r,
                         "Button 1",
                         (void *)1,
                         ButtonUserproc);

    SM_OpenWindow(w);

    /*
    ** Add another button after the window has been opened
    */
    r.Ymin = r.Ymax + 8;
    r.Ymax = r.Ymin + 24;
    b2 = SM_CreateButton(w,
                         &r,
                         "Button 2",
                         (void *)2,
                         ButtonUserproc);
    SM_SetButtonIsdefault(b1, True);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("gadgtwin.out","wb");
    }
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}

int ButtonUserproc(ButtonType *b)
{
    int n;
    WindowType *w;

    n = (int)SM_GetButtonData(b);
    fprintf(ferr,"Button %d activated!\n", n);
    w = SM_GetGadgetWindow(b);
    fprintf(ferr,"Button's parent window is %p\n",w);

    return True;
}

