/*
** pix.c
**
** Demonstrates TWS pixmaps
**
** Copyright 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
** All rights reserved
**
*/

#include    <stdlib.h>
#include    "smtypes.h"
#include    "smwindow.h"
#include    "smevent.h"
#include    "smpixmap.h"
#include    "smcolor.h"
#include    <math.h>

#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif

int main(int argc, char *argv[])
{
    WindowType  *w;
    PixmapType  *pm;
    EventType   *ev;
    int         msg;
    RectType    rt;
    int         i, x, y;
    ColorType   *c;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Pixmap", NULL); /* Create application screen    */

    rt.Xmin = rt.Ymin = 150;
    rt.Xmax = rt.Xmin + 200;
    rt.Ymax = rt.Ymin + 200;
    w = SM_NewWindow(&rt, "Pixmap Demo", DOCUMENT | NOBACKING, NULL, NULL);
    SM_OpenWindow(w);

    /*
    ** Size the pixmap
    */
    rt.Xmin = rt.Ymin = 50;
    rt.Xmax = rt.Xmin + 100;
    rt.Ymax = rt.Ymin + 100;
    pm = SM_CreatePixmap(w, &rt, True);

    /*
    ** Draw in the pixmap
    */
    SM_SetPixmapBlocking(pm, True);
    for (i = 0; i < 5000; i++) {
        c = SM_GetSystemColor(random(7));
        x = random(100) - 50;
        y = random(100) - 50;
        if ((int)sqrt(x*x + y*y) < 35) {
            SM_SetPixmapPixel(pm, x+50, y+50, c);
        }
    }
    SM_SetPixmapBlocking(pm, False);
    c = SM_GetSystemColor(random(7));
    SM_SetPixmapPixel(pm, 50, 50, c);
    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if (ev->ASCII == 'q') {
                SM_Exit(NULL);
            }
        }
    }
}




