/*
** wintestg.c
**
** Test 16 of the SM window system.
** Graphics in a gadget using convert to window
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#include <stdio.h>
#include <string.h>

#ifdef __TURBOC__
#include <alloc.h>
#endif
#ifdef __WATCOMC__
#include <malloc.h>
#endif

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smgadget.h"
#include "smcolor.h"
#include "smgraph.h"
#include "smlabel.h"


#ifdef __TURBOC__
extern unsigned _stklen = 16384U;  /* set stack size to 8K */
#endif

int DrawPalette(LabelType *label);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    RectType    rt;
    LabelType   *l;
    int         r, g, b, i;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Graphics in a Gadget", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+247;
    w = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | NOBACKING, NULL, NULL);
    /*
    ** Create a graphics state. Setting the rectangle to 0 prevents drawing
    ** of a canvas region.
    */
    rt.Xmin = rt.Ymin = rt.Xmax = rt.Ymax = 0;
    GR_CreateGraphState(w, &rt, SMDEFAULT);
    SM_CreateWindowPalette(w, 247);
    r = 255;
    g = 255;
    b = 4;
    for (i = 0; i < 247; i++) {
        b++;
        r--;
        g--;
        SM_SetWindowColor(w, i, r, g, b, SMSHARE);
    }

    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Put a label in the window
    */
    rt.Xmin = rt.Ymin = 3;
    rt.Xmax = -990 ;
    rt.Ymax = 12;
    l = SM_CreateLabel(w,
                       &rt,             /* Bounding box                     */
                       NULL,            /* Label string                     */
                       DrawPalette,     /* Label function                   */
                       ALIGNLEFT,       /* Alignment (ignored for graphics) */
                       False,           /* Bold flag                        */
                       False,           /* Italic flag                      */
                       True,            /* Draw border flag                 */
                       NULL);           /* Data                             */

    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}


int DrawPalette(LabelType *label)
{
    WindowType  *w;
    int         width, depth;
    float       ddx, dx;
    int         i, x, y;
    ColorType   *c;
    RectType    rt;

    /*
    ** Cast label to a window so we can draw in it
    */

    w = SM_GadgetToWindow(label);

    width = SM_GetContentWidth(w);
    depth = SM_GetContentDepth(w);
    ddx = (float)SM_nWindowColors(w) / (float)width;
    dx = -1.0;
    x = 0;
    /*
    ** Draw the colors in the label
    */
    for (i = 0; i < SM_nWindowColors(w); i++) {
        c = SM_GetWindowColor(w, i);
        GR_SetDrawColor(w, c);
        while (dx <= 0.0) {
            GR_DrawLine(w, x, 0, x, depth);
            x++;
            dx += ddx;
        }
        dx -= 1.0;
    }
    SM_FreeWindow(w);
    return 1;
}



