/*
** wintestb.c
**
** Test 11 of the SM window system.
** Checkbox test
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#include <stdio.h>
#include <string.h>

#include <smtypes.h>
#include <smwindow.h>
#include <smevent.h>
#include <smchkbx.h>
#include <smcolor.h>
#include <smgraph.h>

extern FILE *ferr;
int Win_Draw(WindowType *w);

int     cbvalue = 0;
int     ToggleVal(CheckboxType *c);

/*
** Borlandc requires extra stack
*/
#ifdef __TURBOC__
extern unsigned _stklen = 14336U;
#endif


main(int argc, char **argv)
{
    EventType   *ev;
    int         msg, i;
    WindowType  *w;
    CheckboxType *cb[6];
    CheckboxGroupType   *cg;
    RectType    rt;

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Checkbox Gadgets", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+275;
    w = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | NOBACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));
    /*
    ** Create a checkbox
    */
    rt.Xmin = rt.Ymin = 15;
    rt.Xmax = rt.Xmin + GR_StringWidth(" Group CB ") + 20;
    rt.Ymax = rt.Ymin + 20;
    cb[5] = SM_CreateCheckbox(w,
                           &rt,
                           "Lone CB",   /* Label                            */
                           ALIGNLEFT,   /* Button alignment                 */
                           False,       /* Initial selection state          */
                           NULL,        /* User data                        */
                           ToggleVal);  /* User function                    */

//    SM_SetCheckboxType(cb, SMCBOXOVAL);
//    SM_SetCheckboxType(cb, SMCBOXBUTTON);
    SM_SetCheckboxType(cb[5], SMDEFAULT);

    /*
    ** Create a group
    */
    rt.Ymin = rt.Ymax + 44;             /* Put this group under previous cb */
                                        /* Have to be sure to leave lots of */
                                        /* room because checkbox group will */
                                        /* have a title, and titles grow    */
                                        /* upwards from top checkbox        */
    rt.Ymax = rt.Ymin + 20;
    rt.Xmax = 0;                        /* Xmax=0 == boundary self-adjust   */
    cg = SM_CreateCheckboxGroup(w,
                                &rt,
                                "A Group",  /* Group label                  */
                                True,       /* Draw the label and boundary  */
                                NULL);      /* No group level procedure     */
    /*
    ** Add some checkboxes to the group
    */
    for (i = 0; i < 5; i++) {
        rt.Ymin = rt.Ymax + 2;
        rt.Ymax = rt.Ymin + 20;
        cb[i] = SM_AddCheckbox(cg,         /* Group to add checkbox to         */
                            &rt,
                            "Group CB", /* Label                            */
                            ALIGNLEFT,  /* Button alignment                 */
                            False,      /* Initial selection state          */
                            NULL,       /* User data                        */
                            ToggleVal); /* User function                    */
//        SM_SetCheckboxType(cb[i], SMCBOXOVAL);
//        SM_SetCheckboxType(cb[i], SMCBOXBUTTON);
        SM_SetCheckboxType(cb[i], SMDEFAULT);
    }

    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintestb.out","wb");
    }
    i = 0;
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if (i == 5) {
                SM_Exit(NULL);
            }
            SM_SetCheckboxSelected(cb[i]);
            SM_SetCheckboxLabel(cb[i],"Done");
            SM_SetCheckboxType(cb[4-i],SMCBOXBUTTON);
            i++;

        }
    }
}


int ToggleVal(CheckboxType *c)
{
    if (cbvalue) cbvalue = False;
    else cbvalue = True;
    fprintf(ferr, "Checkbox data value is now %d\n",cbvalue);
    return True;
}

