/*
** wintest5.c
**
** Test 5 of the SM window system.
** Attach a menu to an application window
** This program is designed to test:
**
**    * Menu initialization
**    * Menu manipulation
**    * Drop-down submenus
**    * Closing menus
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#include <stdio.h>

#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"

#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    MenuType    *menu;
    MenuType    *winmenu;
    MenuType    *filemenu, *editmenu;
    MenuType    *active, *winfile;
    WindowType  *w, *w2;
    RectType    r;


    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Create the application menu
    */
    menu = SM_CreateMenu();
    filemenu = SM_CreateMenu();
    editmenu = SM_CreateMenu();
    winmenu = SM_CreateMenu();
    SM_AddMenuItem(menu, SUBMENU_ITEM, "File", NULL, filemenu);
    SM_AddMenuItem(menu, SUBMENU_ITEM, "Edit", NULL, editmenu);
    SM_AddMenuItem(menu, ACTION_ITEM, "Quit", NULL, NULL);
    SM_AddMenuItem(filemenu, ACTION_ITEM, "Open", NULL, NULL);
    SM_AddMenuItem(filemenu, ACTION_ITEM, "Save", NULL, NULL);
    active = SM_AddMenuItem(filemenu, ACTION_ITEM, "Inactive Item", NULL, NULL);
    SM_AddMenuItem(filemenu, MENU_DIVIDER, NULL, NULL, NULL);
    SM_AddMenuItem(filemenu, ACTION_ITEM, "Print", NULL, NULL);
    SM_AddMenuItem(filemenu, ACTION_ITEM, "Quit", NULL, NULL);
    SM_AddMenuItem(editmenu, ACTION_ITEM, "Search", NULL, NULL);
    SM_AddMenuItem(editmenu, ACTION_ITEM, "Replace", NULL, NULL);
    SM_AddMenuItem(editmenu, SUBMENU_ITEM, "Configure", NULL, NULL);
    SM_AddMenuItem(editmenu, ACTION_ITEM, "Cut", NULL, NULL);
    SM_AddMenuItem(editmenu, ACTION_ITEM, "Copy", NULL, NULL);
    SM_AddMenuItem(editmenu, ACTION_ITEM, "Paste", NULL, NULL);

    SM_AddMenuItem(winmenu, SUBMENU_ITEM, "File", NULL, filemenu);

    SM_SetMenuInactive(active);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Pull-down menus", menu); /* Create application screen    */

    /*
    ** Create and open an application window
    */
    r.Xmin = r.Ymin = 120;
    r.Xmax = r.Ymax = 400;
    w = SM_NewWindow(&r, "Test Window 1", DOCUMENT | NOBACKING, winmenu, NULL);
    r.Xmin += 150;
    r.Ymin += 30;
    r.Xmax += 100;
    r.Ymax += 50;
    w2 = SM_NewWindow(&r, "Test Window 2", DOCUMENT | NOBACKING, winmenu, NULL);
    SM_OpenWindow(w);
    SM_OpenWindow(w2);
    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}


