/*
** wintest4.c
**
** Test 4 of the SM window system.
** Create and open a document window inside the desktop.
** This program is designed to test:
**
**    * Application window initialization
**    * Application window displaying
**    * Application window manipulators (drag, resize, close)
**    * Closing an application window
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Mon  06-29-1992
** Original version
*/

#include <stdio.h>

#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"
#include "smtypes.h"

#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif


main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    MenuType    *menu;
    WindowType  *w1, *w2, *w3;
    RectType    r;
    int         i = 0;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Create the application menu
    */
    menu = SM_CreateMenu();
    SM_AddMenuItem(menu, SUBMENU_ITEM, "File", NULL, NULL);
    SM_AddMenuItem(menu, ACTION_ITEM, "Quit", NULL, NULL);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Resizeable Windows", menu);

    /*
    ** Create and open an application window
    */
    r.Xmin = r.Ymin = 100;
    r.Xmax = r.Ymax = 600;
    w1 = SM_NewWindow(&r, "Test Window 1", DOCUMENT | NOBACKING, NULL, NULL);
    SM_OpenWindow(w1);
    r.Xmin = 120;
    r.Ymin = 120;
    r.Xmax = 320;
    r.Ymax = 320;
    w2 = SM_NewWindow(&r, "Test Window 2", DOCUMENT | NOBACKING, NULL, NULL);
    SM_OpenWindow(w2);
    r.Xmin += 20;
    r.Ymin += 20;
    r.Xmax += 20;
    r.Ymax += 20;
    w3 = SM_NewWindow(&r, "Test Window 3", DOCUMENT | NOBACKING, NULL, NULL);
    SM_OpenWindow(w3);
    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if (i == 0) {
                SM_CloseWindow(w2);
            }
            else if (i == 1) {
                SM_CloseWindow(w1);
            }
            else {
                SM_Exit(NULL);
            }
            i++;
        }
    }
}


