/*
** windraw.c
**
** Test 14 of the SM window system.
** Interactive graphics demo.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Wed  09-02-1992
** Original version
*/

#include "stdio.h"

#include "smwindow.h"
#include "smtypes.h"
#include "smevent.h"
#include "smgraph.h"
#include "smmenu.h"
#include "smlabel.h"
#include "smtext.h"
#include "smbutton.h"


/*
** Borlandc requires extra stack
*/
#ifdef __TURBOC__
extern unsigned _stklen = 14336U;
#endif


void main(int argc, char *argv[]);
int TWSDraw(WindowType *w, EventType *ev);

int About(WindowType *w);
int HowItWorks(WindowType *w);
int CloseAbout(ButtonType *b);
int ResizeText(WindowType *w);

void main(int argc, char *argv[])
{
    WindowType  *w;
    RectType    r;
    EventType   *ev;
    int         msg;
    MenuType    *menu;

    /*
    ** Initialize and open the application desktop
    */
    SM_Init(argc, argv);

    /*
    ** Build the application menu
    */
    menu = SM_CreateMenu();
    SM_AddMenuItem(menu, ACTION_ITEM, "About...", About, NULL);
    SM_AddMenuItem(menu, ACTION_ITEM, "Source Code", HowItWorks, NULL);
    SM_AddMenuItem(menu, ACTION_ITEM, "Quit", SM_Exit, NULL);

    SM_OpenApplication("TWS Draw", menu);

    /*
    ** Create the drawing window
    */
    r.Xmin = r.Ymin = 100;
    r.Xmax = r.Ymax = 350;
    w = SM_NewWindow(&r, "Picture", DOCUMENT | NOBACKING, NULL, NULL);
    GR_CreateGraphState(w, NULL, SMDEFAULT);
    SM_SetWindowProc(w, TWSDraw);
    SM_OpenWindow(w);

    /*
    ** The ubiquitous event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}



int TWSDraw(WindowType *w, EventType *ev)
{
    static int  oldx = -1, oldy = -1;
    int         x, y, nx, ny;
    int         state;

    /*
    ** We know if we get here that the window is the focus window, but we
    ** don't know if the event occured in this window.  We can check it...
    */
    if ((ev->event_type & LEFTBUTTONACTIVE) && (ev->region == CANVAS_REGION)) {
        /*
        ** While we're drawing we want to XOR the line so it can appear to
        ** move along with the cursor
        */
        GR_SetDrawMode(w, SMXOR);

        GR_GetMouse(w, &state, &x, &y);
        /*
        ** If the old point is negative then we haven't been here before
        ** so set the anchor point to the current point
        */
        if (oldx == -1) {
            oldx = x;
            oldy = y;
        }

        GR_DrawLine(w, oldx, oldy, x, y);

        /*
        ** While the mouse button is down we want to trap it and draw a
        ** rubber-band line to follow it around
        */
        while (state & LEFTBUTTONACTIVE) {
            /*
            ** If the new cursor position is different from the previous
            ** position then erase the previous line and draw a new one
            */
            GR_GetMouse(w, &state, &nx, &ny);
            if ((nx != x) || (ny != y)) {
                GR_DrawLine(w, oldx, oldy, x, y);   /* Erase old line       */
                GR_DrawLine(w, oldx, oldy, nx, ny); /* Draw new line        */
                x = nx;                 /* Save new cursor position         */
                y = ny;
            }
        }

        /*
        ** At this point the left mouse button is not pressed.
        ** Set the line mode to overwrite and draw the line again
        */
        GR_SetDrawMode(w, SMREP);
        GR_DrawLine(w, oldx, oldy, x, y);
        oldx = x;
        oldy = y;
    }
    return ev->event_type;
}





int About(WindowType *w)
{
    WindowType  *about;
    RectType    rt;

    rt.Xmin = 50;
    rt.Ymin = 175;
    rt.Xmax = rt.Xmin + 400;
    rt.Ymax = rt.Ymin + 175;
    about = SM_NewWindow(&rt, "About Windraw", DIALOG | NOBACKING, NULL, NULL);
    rt.Xmin = 1;
    rt.Xmax = -999;
    rt.Ymin = -200;
    rt.Ymax = -275;
    SM_CreateLabel(about,&rt,"WINDRAW",NULL,ALIGNCENTER,False,False,False,NULL);
    rt.Ymin = rt.Ymax - 10;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "Simple interactive line drawing for the TWS Window System",
                   NULL, ALIGNCENTER, False, False, False,NULL);
    rt.Ymin = rt.Ymax - 175;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "Release:",
                   NULL, ALIGNCENTER, False, False, False,NULL);
    rt.Ymin = rt.Ymax - 10;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "4.0",
                   NULL, ALIGNCENTER, False, False, False,NULL);

    rt.Xmin = -400;
    rt.Xmax = -600;
    rt.Ymax = SM_GetContentDepth(about) - 10;
    rt.Ymin = rt.Ymax - 30;
    SM_CreateButton(about,
                    &rt,
                    "OK",
                    NULL,
                    CloseAbout);
    SM_OpenWindow(about);
}


int CloseAbout(ButtonType *b)
{
    SM_CloseWindow(SM_GetGadgetWindow(b));
    return True;
}


int HowItWorks(WindowType *w)
{
    WindowType  *works;
    RectType    rt;
    TextboxType *tb;

    rt.Xmin = rt.Ymin = 150;
    rt.Xmax = rt.Xmin + 500;
    rt.Ymax = rt.Ymin + 350;
    works = SM_NewWindow(&rt, "Windraw.c", DOCUMENT | NOBACKING, NULL, NULL);
    rt.Xmin = rt.Ymin = 1;
    rt.Xmax = SM_GetContentWidth(works) - 2;
    rt.Ymax = SM_GetContentDepth(works) - 2;
    tb = SM_CreateTextbox(works,
                          &rt,
                          "windraw.c",
                          SM_GetSystemFont(),
                          True,
                          False,
                          NULL);
    SM_SetResizeProc(works, ResizeText);
    SM_SetUserData(works, (void *)tb);
    SM_OpenWindow(works);
}


int ResizeText(WindowType *w)
{
    TextboxType *tb;
    RectType    rt;

    tb = (TextboxType *)SM_GetUserData(w);
    rt.Xmin = rt.Ymin = 1;
    rt.Xmax = SM_GetContentWidth(w) - 2;
    rt.Ymax = SM_GetContentDepth(w) - 2;
    SM_SetTextboxRect(tb, &rt);
}


