

#ifndef TOOLKIT_H
#define TOOLKIT_H

/*
** Define machine-specific features
*/
#ifdef __WATCOMC__
#define PROTOTYPING     1
#define HOSTBYTESWAPPED 0
#define EXIT_SUCCESS    0
#define EXIT_FAILURE    1
#define BITSPERBYTE     8
#define SIZEOFINT       sizeof(int)
#define SIZEOFLONG      sizeof(long)

#else
#include "host.h"
#endif

#ifndef STATIC
#define STATIC static
#endif

#define ARRAYSIZE(array)    (sizeof(array) / sizeof(array[0]))

/*
** Prototyping macros
*/

#if PROTOTYPING
#ifdef MSC
#define _0
#else
#define _0                                  void
#endif
#define _1(v)                               v
#define _2(v1,v2)                           v1,v2
#define _3(v1,v2,v3)                        v1,v2,v3
#define _4(v1,v2,v3,v4)                     v1,v2,v3,v4
#define _5(v1,v2,v3,v4,v5)                  v1,v2,v3,v4,v5
#define _6(v1,v2,v3,v4,v5,v6)               v1,v2,v3,v4,v5,v6
#define _7(v1,v2,v3,v4,v5,v6,v7)            v1,v2,v3,v4,v5,v6,v7
#define _8(v1,v2,v3,v4,v5,v6,v7,v8)         v1,v2,v3,v4,v5,v6,v7,v8
#define _9(v1,v2,v3,v4,v5,v6,v7,v8,v9)      v1,v2,v3,v4,v5,v6,v7,v8,v9
#define _10(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10) v1,v2,v3,v4,v5,v6,v7,v8,v9,v10

#else

#define _0
#define _1(v)
#define _2(v1,v2)
#define _3(v1,v2,v3)
#define _4(v1,v2,v3,v4)
#define _5(v1,v2,v3,v4,v5)
#define _6(v1,v2,v3,v4,v5,v6)
#define _7(v1,v2,v3,v4,v5,v6,v7)
#define _8(v1,v2,v3,v4,v5,v6,v7,v8)
#define _9(v1,v2,v3,v4,v5,v6,v7,v8,v9)
#define _10(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)

#endif

#if PROTOTYPING
#define P(s)    s
#else
#define P(s)    ()
#endif

#ifdef DEBUG
#define debug(a)    (a)
#else
#define debug(a)
#endif

#endif


