/*
** smwindow.h
**
** Public header for windows functionality. Every program that uses the
** window system must include this file
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Mon  10-19-1992
** Added linewidth field to graphics state struct
**
*/

#ifndef SMWINDOW_H
#define SMWINDOW_H


#include "smtypes.h"                    /* Basic types and constants        */
#include "smmenup.h"                    /* Menu gadget definition           */
#include "smeventp.h"                   /* Event type definitions           */

/*
** Window default structure
*/
typedef struct _def {
    int         border_width;               /* Width of window scale regions*/
    int         title_bar_depth;            /* Width of title bar           */
    int         menu_bar_depth;             /* Width of menu bar            */
    ColorType   *active_title_bar_color;
    ColorType   *active_border_color;
    ColorType   *inactive_title_bar_color;
    ColorType   *inactive_border_color;
    ColorType   *title_font_color;
    ColorType   *active_up_bevel_color;
    ColorType   *active_down_bevel_color;
    ColorType   *inactive_up_bevel_color;
    ColorType   *inactive_down_bevel_color;
    ColorType   *text_color;
    ColorType   *content_color;
    ColorType   *desktop_color;
    ColorType   *menu_color;
    ColorType   *menu_text_color;
    ColorType   *inactive_menu_text_color;
    FontType    system_font;
    FontType    title_font;
    FontType    text_font;
    RectType    screen;
    int         menu_spacing;
    long        colors;
    int         white_index;
    int         color_scheme;
    int         truecolor;
    char        *font_dir;
    char        *graph_device;
    char        *mouse_device;
    char        *sysdevice;
    char        *app_title;
    int         fncntr;                 /* Incremental counter for tmp file */
    int         icon_align;             /* Icon alignment (top, right, etc.)*/
    int         icon_next_pos;          /* Next icon position               */
    int         iconx;                  /* Icon X position                  */
    int         icon_width;             /* Default icon width               */
    int         icon_depth;             /* Default icon depth               */
    int         bevel_depth;            /* 3D effect depth                  */
    int         limit_windows;          /* If True restrict window size     */
} WinDefaultsType;



/*
** The graphics state
*/
typedef struct {
    int         gx, gy;                 /* Graphics cursor location         */
    int         tx, ty;                 /* Text cursor location             */
    ColorType   *palette;               /* Color palette                    */
    int         ncolors;                /* Number of colors in the palette  */
    ColorType   *forecolor;             /* Graphics foreground color        */
    ColorType   *backcolor;             /* Graphics background color        */
    ColorType   *tcolor;                /* Text color                       */
    int         penmode;                /* Xor, And, etc.                   */
    int         linewidth;
    int         linestyle;
    int         textmode;
    FontType    *font;                  /* Text font                        */
    RectType    devicecanvas;           /* Drawable region in device coords */
    RectType    canvas;                 /* Drawable region in user coords   */
    char        *save_file;             /* Save-under storage file          */
    int         step;                   /* Number of save-under buffers     */
    RectType    buffrect[64];
    int         canvasborder;           /* Flag for drawable region border  */
} GraphStateType;


/*
** The window structure
*/
typedef struct _win {
    /*
    ** Window display regions
    */
    RectType window;                     /* Max extent of complete window    */
    RectType content;                    /* Drawing area                     */
    RectType orig_content;               /* Old content region for max       */
    RectType titlebar;
    RectType stretch_left,               /* Window 'grab' regions            */
             stretch_up,
             stretch_right,
             stretch_down,
             menubutton,
             iconize,
             fullscreen;
    PolygonType upleft,
            upright,
            downleft,
            downright;
    RectType windowmenu;                 /* Window menu region               */

    /*
    ** Minimum width/height for the window
    */
    int     minx, miny;

    char    *title;                     /* Titlebar title                   */
    void    *icon;                      /* Icon version of the window       */
    int     is_icon;                    /* TRUE if window is iconized       */
    int     is_maximized;               /* TRUE if window is maximized      */
    int     type;                       /* Window type                      */
    void    *data;                      /* User-defined data                */
    void    *gadgets;                   /* Window gadget list               */
    /*
    ** Window procedures
    */
    int     (*windrawproc)(struct _win *);/* Procedure for drawing win borders*/
    int     (*drawproc)(struct _win *);   /* Procedure for drawing contents   */
    int     (*redrawproc)(struct _win *); /* Procedure for redrawing contents */
    int     (*resizeproc)(struct _win *); /* Procedure for redrawing contents */
    int     (*userproc)(struct _win *, EventType *);
    int     (*closeproc)(struct _win *);  /* Procedure when window closed     */
    int     (*losefocusproc)(struct _win *);
    int     (*getfocusproc)(struct _win *);
    /*
    ** The window graphics state
    */
    GraphStateType *gs;
    /*
    ** Content region colors
    */
    int     ncolors;                    /* Size of the window color table   */
    MenuType *menu;                     /* Window menu                      */
    ColorType content_color;            /* Color of content region          */
    int     redraw;                     /* TRUE if window needs to be drawn */
    int     locked;                     /* TRUE if window is locked         */
    struct _win *next, *prev;
} WindowType;

typedef WindowType  PanelType;

/*
** Function prototypes
*/
int         SM_BringToFront(WindowType *w);
int         SM_CloseAllWindows(void);
int         SM_CloseWindow(WindowType *w);
PanelType  *SM_CreatePanel(int size, int location);
WindowType *SM_FocusWindow(void);
int         SM_DoNothing(WindowType *w);
void        SM_DrawAppTitle(void);
void        SM_DrawWindow(WindowType *w);
int         SM_DrawControls(WindowType *w);
int         SM_EraseContent(WindowType *w);
int         SM_Exit(WindowType *w);
void        SM_FreeWindow(WindowType *w);
int         SM_GetColorScheme(void);
ColorType  *SM_GetContentColor(WindowType *w);
RectType   *SM_GetContentRect(WindowType *w);
int         SM_GetContentDepth(WindowType *w);
int         SM_GetContentWidth(WindowType *w);

int         SM_GetDefaultBorderWidth(void);
int         SM_GetDefaultBevelDepth(void);
int         SM_GetDefaultMenubarDepth(void);
ColorType  *SM_GetDefaultTextColor(void);
int         SM_GetDefaultTitlebarDepth(void);
int         SM_GetDisplayDepth(void);
int         SM_GetDisplayWidth(void);
GraphStateType *SM_GetGraphState(WindowType *w);
FontType    *SM_GetSystemFont(void);
int         SM_GetSystemFontDescent(void);
int         SM_GetSystemFontHeight(void);
ColorType  *SM_GetTextColor(void);
FontType   *SM_GetTextFont(void);
int         SM_GetTitleFontHeight(void);
void       *SM_GetUserData(WindowType *w);
char       *SM_GetWindowTitle(WindowType *w);
int         SM_Init(int argc, char *argv[]);
int         SM_IsFocus(WindowType *w);
int         SM_IsMaximized(WindowType *w);
int         SM_IsMinimized(WindowType *w);
int         SM_IsRedraw(WindowType *w);
int         SM_LoadSystemFont(char *);
void        SM_LockWindow(WindowType *w);
int         SM_MoveWindow(WindowType *w, int dx, int dy);
int         SM_nDisplayBits(void);
int         SM_nDisplayPlanes(void);
WindowType *SM_NewWindow(RectType   *size,
                         char       *title,
                         int        type,
                         MenuType   *defaultmenu,
                         void       *data);
WindowType *SM_OpenApplication(char *title, MenuType *menu);
void        SM_OpenWindow(WindowType *w);
int         SM_RedrawWindow(WindowType *w);
int         SM_ResizeWindow(WindowType *w, int dx, int dy);
int         SM_SaveContent(WindowType *win);
void        SM_SetApplicationMenu(MenuType *m);
void        SM_SetApplicationTitle(char *);
void        SM_SetCloseProc(WindowType *w, int (*closeproc)());
void        SM_SetContentColor(WindowType *w, ColorType *color);
int         SM_SetContentRect(WindowType *w, RectType *r);

void        SM_SetDrawProc(WindowType *w, int (*proc)());
void        SM_SetGainFocusProc(WindowType *w, int (*f)());
void        SM_SetLoseFocusProc(WindowType *w, int (*f)());
void        SM_SetMenu(WindowType *w, MenuType *m);
void        SM_SetRedrawFlag(WindowType *w, int flag);
void        SM_SetRedrawProc(WindowType *w, int (*proc)());
void        SM_SetResizeProc(WindowType *w, int (*proc)());
void        SM_SetTitle(WindowType *w, char *title);
void        SM_SetUserData(WindowType *w, void *data);
void        SM_SetWindow(WindowType *w);
void        SM_SetWindowProc(WindowType *w, int (*proc)());
void        SM_SetWindowTitle(WindowType *w, char *title);
int         SM_StringWidth(char *string, FontType *font, int face);
void        SM_UnlockWindow(WindowType *w);
int         SM_WindowExists(WindowType *w);
int         SM_WindowRegion(WindowType *w, int x, int y);
WindowType *SM_WorkspaceWindow(void);


#endif

