/*
** smwindod.h
**
** Header file for device-dependent window manager routines.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 28 May 1992
** Original version
*/

#ifndef SMWINDOD_H
#define SMWINDOD_H

#include "smwindow.h"                   /* Window definitions               */
#include "smutil.h"                     /* Global utilities                 */

/*
** Function prototypes
*/
void        Beep(void);
void        BringToFront(WindowType *w);
RectType   *GetTitlebarRect(WindowType *w);
RectType   *GetContentRect(WindowType *w);
RectType   *GetMenuRect(WindowType *w);
void        InitColors(void);
void        InitDefaultColors(void);
void        InitDefaults(void);
int         InitFonts(void);
void        smInitGraphics(int argc, char *argv[]);
void        InitWindowStack(void);
int         IsObscured(WindowType *w);
void        Maximize(WindowType *w);
void        Minimize(WindowType *w);
int         MoveTheWin(WindowType *w, int tx, int ty);
void        MoveWindow(WindowType *w);
PanelType  *PanelSelected(int x, int y);
void        PopWindowStack(void);
WindowType *PtInWindow(int x, int y);
void        PushWindow(WindowType *w);
void        RestoreDesktop(int i,      /* Number of rects exposed          */
                            RectType *r1,   /* The rectangles to clip to        */
                            RectType *r2);
void        ScaleWindow(int direction);
void        SetDialogWindow(WindowType *w);
void        SetDocumentWindow(WindowType *w);
void        SetSimpleWindow(WindowType *w);
long        smGetDefaultColors(void);
void        SM_SetPalette(WindowType *w, ColorType *pal, int ncolors);
void        SetWindow(WindowType *w);
void        ShiftWindow(WindowType *w, int x1, int y1);
WindowType *StackTop(void);
WindowType *StackBase(void);
int         SystemFontHeight(void);
int         SystemFontDescent(void);
int         TitleFontHeight(void);
void        Unstack(WindowType *w);
int         WindowIntersect(WindowType *ww);
int         WindowIntersectAll(WindowType *ww);
int         WindowIntersectRect(WindowType *ww, RectType *r);
int         WindowRegion(WindowType *w, int x, int y);
WindowType *WindowSelected(int x, int y);

void        FreeFonts(void);


#endif
