/*
** smmessag.h
**
** Header file for TWS messaging system
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**                     
** Revision history :
**
** Fri  07-10-1992
** Original version
*/

#ifndef SMMESSAG_H
#define SMMESSAG_H

#define MSGUNUSED   0x7ffe

typedef int     MessageType;
typedef int     SenderType;
typedef void    *UserDataType;

/*
** Message type
*/
typedef struct {
    MessageType     message;
    SenderType      from;
    SenderType      to;
    UserDataType    data;
} MessagePacketType;

/*
** Function prototypes
*/
int         SM_GetMessage(MessageType type, MessagePacketType *msg);
int         SM_GetMessageFor(SenderType to, MessagePacketType *msg);
UserDataType SM_GetMessageData(MessagePacketType *msg);
SenderType  SM_GetMessageDestination(MessagePacketType *msg);
SenderType  SM_GetMessageSender(MessagePacketType *msg);
MessageType SM_GetMessageType(MessagePacketType *msg);
int         SM_InitMessage(void);
MessageType SM_PeekMessage(void);
int         SM_PostMessage(MessageType msg,
                           SenderType from,
                           SenderType to,
                           UserDataType data);

#endif
