/*
** smicon.h
**
** Header for window icon routines
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#ifndef SMICON_H
#define SMICON_H

#define SMNOFILE    1
#define SMICONVER   2
#define SMICONID    0x3251

#include    <smlabel.h>

/*
** The icon data structure
*/
typedef struct {
    char        *title;                 /* String label for the icon        */
    WindowType  *parentwin;             /* Window the icon belongs to       */
    PixmapType  *pixmap;                /* Icon image                       */
    LabelType   *label;                 /* Icon label                       */
    int         x, y;                   /* Icon absolute position           */
    char        *screenunder;           /* Screen under the icon            */
    int         (*dropfunc)();          /* Drop function for drag-n-drop    */
    void        *data;                  /* User data                        */
} IconType;


void        SM_MoveIcon(WindowType *w, int tx, int ty);
IconType   *SM_CreateIcon(WindowType *w, char *title, PixmapType *pm);
IconType   *CreateDefaultIcon(void);


#endif

