/*
** smevent.h
**
** Header file for TWS event handler
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
** 22 April 92
** Initial version
*/

#ifndef EVENTTYPE_H
#define EVENTTYPE_H

/*
** Need some basic type definitions for SM system
*/

/*
#include "smtypes.h"
#include "smeventp.h"
#include "smwindow.h"
*/


/*
** Define the different event types; start with mouse events
*/
#define RIGHTBUTTONACTIVE   0x0002      /* Right button is down             */
#define MIDDLEBUTTONACTIVE  0x0004      /* Middle button is active          */
#define LEFTBUTTONACTIVE    0x0001      /* Left button is down              */
#define ANYBUTTONACTIVE     0x0007      /* Any button is down               */
#define RIGHTBUTTONDOWN     0x0200      /* Right mouse button down trans.   */
#define MIDDLEBUTTONDOWN    0x0400      /* Middle button transition         */
#define LEFTBUTTONDOWN      0x0100      /* Left mouse button down trans.    */
#define ANYBUTTONDOWN       0x0700      /* Any mouse button down transition */
#define ANYBUTTONUP         0x0008
#define DOUBLECLICK         0x0800      /* "double click"                   */
#define CLOCKTICK           0x0010
#define CURSORMOVE          0x0020      /* The mouse cursor position changed*/
#define KEYPRESS            0x0040      /* An alpha keyboard key was pressed*/
#define ENTERKEY            0x0080      /* The enter key was pressed        */
#define NOEVENTSPENDING     0x1000
#define NOTOBSCURED         0x2000      /* Only when window not covered     */
#define ACTIVEONLY          0x4000      /* User event handler should be     */
                                        /* called only if the handler       */
                                        /* window is the active window      */
#define INACTIVEONLY        0x8000      /* User event handler should be     */
                                        /* called only if the handler       */
                                        /* window is not the active window  */
#define ALLEVENTS           0x0fff      /* User event handler should be     */
                                        /* called on every loop             */
#define NOEVENTS            0x0000      /* Ignore events                    */

/*
** Window happenings
*/
#define EV_NONE             100      
#define EV_WINMOVE          101
#define EV_WINMENU          102
#define EV_BASEMENU         103
#define EV_CHANGEWIN        104
#define EV_NEWWIN           105
#define EV_CLOSEWIN         106
#define EV_WINSIZE          107

/*
** Mouse/keyboard state constants
*/
#define RIGHTSHIFTDOWN      1
#define LEFTSHIFTDOWN       (1<<1)
#define CTRLDOWN            (1<<2)
#define ALTDOWN             (1<<3)
#define SCROLLOCKON         (1<<4)
#define NUMLOCKON           (1<<5)
#define CAPSLOCKON          (1<<6)
#define INSERTON            (1<<7)
#define LEFTCTRLDOWN        (1<<8)
#define LEFTALTDOWN         (1<<9)
#define SYSREQDOWN          (1<<10)
#define CTRLNUMLOCK         (1<<11)
#define SCROLLOCKDOWN       (1<<12)
#define NUMLOCKDOWN         (1<<13)
#define CAPSLOCKDOWN        (1<<14)
#define INSERTDOWN          (1<<15)

typedef int (*BackgroundProcType)(WindowType *, EventType *) ;
typedef unsigned int EventFlagsType;
typedef unsigned int BackgroundProcIDType;

/*
** Application background procedure list node
*/
typedef struct _enode {
    BackgroundProcIDType id;            /* Node ID                          */
    EventFlagsType  events;             /* Types of events that trigger     */
    WindowType      *w;                 /* Parent window of this function   */
    int             (*evfunc)(WindowType *w, EventType *e);
    struct _enode   *next, *prev;       /* Links                            */
} BackgroundProcNodeType;

/*
** Background procedure list structure
*/
typedef struct {
    int                     npending;   /* Number of events on the list     */
    int                     nalloced;   /* Number of events allocated       */
    BackgroundProcNodeType  *events;    /* List of background procedures    */
} BackgroundProcListType;

/*
** Interface function prototypes
*/
int         SM_CallBackgroundProc(WindowType *w, EventType *evnt);
int         SM_CallBackgroundProcs(WindowType *w, EventType *evnt);
int         SM_GetMouse(WindowType *w, int *state, int *x, int *y);
EventType  *SM_GetNextEvent(void);       /* Returns the next pending event   */
long        SM_GetSystemTime(void);
int         SM_InitBackgroundProcs(void);
int         SM_InitEvents(void);
int         SM_ProcessEvent(EventType *smevent);

BackgroundProcIDType SM_RegisterBackgroundProc(
    WindowType *,                       /* Parent window                    */
    BackgroundProcType,                 /* User background procedure        */
    EventFlagsType);                    /* Events proc is interested in     */
int         SM_RemoveBackgroundProc(BackgroundProcIDType);
int         SM_StopEvent(void);
int         SM_TimeOfDay(long t, int *hr, int *min, int *sec);
int         SM_GetEventState(EventType *evnt);
int         SM_GetEventRegion(EventType *evnt);
void        SM_GetEventKey(EventType *evnt, char *ascii, char *scan);
void        SM_GetEventCursor(EventType *evnt, int *x, int *y);
int         SM_GetEventButtons(EventType *evnt);
void        SM_SetPrintscreenProc(WindowType *w, RectType *r, char *fname, void (*f)());
    
#endif
