/*
** smeditst.h
**
** Public header for the editstring gadget.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 27 May 1992
** Original version
**
** 15 Sept 1992
** Revised to eliminate the obsolete 'control' structure in favor of the
** generic 'gadget' structure. See smgadget.h for details.
*/

#ifndef SMEDITST_H
#define SMEDITST_H

/*
#include "smtypes.h"
#include "smwindow.h"
#include "smeventp.h"
*/
#include "smgadget.h"                   /* Generic gadget definition        */

/*
** Editstring type definition
*/
typedef struct _etext {
	GadgetType *gadget;					/* Superclass gadget				*/
    char    *string;                    /* String to be edited              */
    int     maxlength;                  /* Allocated string space           */
    int     cursorpos;                  /* Index in string where cursor is  */
    int     headpos;                    /* Index where string is drawn      */
    ColorType  *backcolor;              /* Background color                 */
    ColorType  *textcolor;              /* Text color                       */
    int     boldflg;                    /* TRUE if string is bolded         */
    int     italflg;                    /* TRUE if string is italicized     */
    int     insert;                     /* Insert/overwrite mode flag       */
    int     xalign;						/* Horizontal string alignment		*/
    int     start_highlight;            /* First index of highlight block   */
    int     end_highlight;              /* Last index of highlight block    */
    int     active;                     /* True if this string is active    */
    void    *data;                      /* User data                        */
    int     (*action)();                /* User callback function           */
    int     group;                      /* Editstring group                 */
} EditstringType;


/*
** Function prototypes
*/
EditstringType *SM_CreateEditstring(WindowType *w,
                                    RectType *box,
                                    char *str,
                                    int maxstr,
                                    void *data,
                                    int (*f)());
int     SM_SetEditstringString(EditstringType *e, char *s);
int     SM_SetEditstringCursorpos(EditstringType *e, int a);
int     SM_SetEditstringActive(EditstringType *e, int a);
char   *SM_GetEditstringString(EditstringType *e);
int     SM_GetEditstringCursorpos(EditstringType *e);
int     SM_GetEditstringActive(EditstringType *e);
int     SM_DestroyEditstring(EditstringType *s);
void    SM_SetEditstringGroup(EditstringType *e, int group);
int     SM_GetEditstringGroup(EditstringType *e);

#endif

