/*
** calc.c
**
** Test of the TWS window system.
** Calculator demo
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Sat  09-26-1992
** Original version
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include <math.h>
#include <dos.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smgadget.h"
#include "smevent.h"
#include "smcolor.h"
#include "smgraph.h"
#include "smlabel.h"
#include "smbutton.h"
#include "smmenu.h"
#include "smtext.h"


/*
** Global storage for calculator inputs
*/
static char currinput[80];
static double part = 0.0;
static char currop = (char)0;

int CalcExit(WindowType *w);
int EnterNumber(ButtonType *b);
int EnterOp(ButtonType *b);
int CalcResult(ButtonType *b);
int CloseAbout(ButtonType *b);
int ClearNumbers(ButtonType *b);

int About(WindowType *w);
int HowItWorks(WindowType *w);
int CloseAbout(ButtonType *b);
int ResizeText(WindowType *w);

/*
** Borlandc requires extra stack
*/
#ifdef __TURBOC__
extern unsigned _stklen = 14336U;
#endif



main(int argc, char **argv)
{
    int         i;
    EventType   *ev;
    int         msg;
    WindowType  *w;
    RectType    rt;
    LabelType   *label;
    MenuType    *menu;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Build the application menu, just 2 items
    */
    menu = SM_CreateMenu();
    SM_AddMenuItem(menu, ACTION_ITEM, "About...", About, NULL);
    SM_AddMenuItem(menu, ACTION_ITEM, "Source Code", HowItWorks, NULL);
    SM_AddMenuItem(menu, ACTION_ITEM, "Quit", CalcExit, NULL);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Calc", menu);

    /*
    ** Create the calculator window
    */
    rt.Xmin = rt.Ymin = 100;
    rt.Xmax = rt.Ymax = 355;
    w = SM_NewWindow(&rt, "TWSCalc", DIALOG, NULL, NULL);

    /*
    ** Use a label to display the input and results
    */
    rt.Xmin = rt.Ymin = 3;
    rt.Xmax = -990;
    rt.Ymax = -160;
    label = SM_CreateLabel(w,           /* Label's parent window            */
                           &rt,         /* Label boundary                   */
                           "0",         /* Initial label string             */
                           NULL,        /* Graphics label function          */
                           ALIGNRIGHT,
                           False,       /* Bold?                            */
                           False,       /* Italics?                         */
                           SCULPTED,    /* Bordered?                        */
                           NULL);

    BuildButtons(w, label);
    SM_OpenWindow(w);

    /*
    ** Initialize the input string
    */
    for (i = 0; i < 80; i++) {
        currinput[i] = (char)0;
    }

    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if (ev->ASCII == 'q') {
                SM_Exit(NULL);
            }
        }
    }
}



/***************************************************************************
**
** BuildButtons
**
** Add the number keypad buttons. Note they're 'virtual' buttons.
** Even though the calculator window isn't resizeable, by using
** virtual measures we can change the entire calculator just by
** changing the dialog window's dimensions and recompiling -- we
** won't have to figure out new button sizes.
*/
int BuildButtons(WindowType *w, LabelType *label)
{
    RectType    rt;
    int         i, k;
    char        *numerals[] = {"0","7","8","9","4","5","6","1","2","3"};
    char        *ops[] = {"/","*","-"};

    /*
    ** Start in the upper left corner, right under the label
    */
    rt.Xmin = 1;
    rt.Xmax = -248;
    rt.Ymin = -170;
    rt.Ymax = -333;

    /*
    ** Build three rows of number buttons
    */
    for (k = 0; k < 3; k++) {
        /*
        ** Build the first rows
        */
        for (i = 1; i < 4; i++) {
            SM_CreateButton(w,              /* Button's parent window       */
                            &rt,            /* Button boundary              */
                            numerals[i+k*3],/* Button label string          */
                            (void *)label,  /* User data                    */
                            EnterNumber);   /* Callback function            */
            /*
            ** Adjust the button to the right
            */
            rt.Xmin = rt.Xmax - 4;
            rt.Xmax = rt.Xmin - 247;
        }
        /*
        ** Operators at end of number rows
        */
        rt.Xmax = -995;
        SM_CreateButton(w, &rt, ops[k], (void *)label, EnterOp);

        /*
        ** Adjust the button down and back to the left edge
        */
        rt.Xmin = 1;
        rt.Xmax = -248;
        rt.Ymin = rt.Ymax - 4;
        rt.Ymax = rt.Ymin - 163;
    }
    /*
    ** Build the larger 0 button
    */
    rt.Xmax = -499;
    SM_CreateButton(w, &rt, numerals[0], (void *)label, EnterNumber);

    /*
    ** Decimal and plus
    */
    rt.Xmin = rt.Xmax - 4;
    rt.Xmax = rt.Xmin - 247;
    SM_CreateButton(w, &rt, ".", (void *)label, EnterNumber);
    rt.Xmin = rt.Xmax - 4;
    rt.Xmax = -995;
    SM_CreateButton(w, &rt, "+", (void *)label, EnterOp);



    /*
    ** Do the remaining buttons - operators, clear, etc.
    */
    rt.Ymin = rt.Ymax - 4;
    rt.Ymax = -995;
    rt.Xmin = 1;
    rt.Xmax = -499;
    SM_CreateButton(w, &rt, "CLEAR", (void *)label, ClearNumbers);

    rt.Xmin = -503;
    rt.Xmax = -995;
    SM_CreateButton(w, &rt, "=", (void *)label, CalcResult);

}



/**************************************************************************
**
** EnterNumber
**
** Callback function for the numeral buttons on the calculator
*/
int EnterNumber(ButtonType *b)
{
    int     i;
    char    *s;
    LabelType   *l;

    /*
    ** The button label is the numeral
    */
    s = SM_GetButtonLabel(b);
    currinput[strlen(currinput)] = *s;

    /*
    ** Retrieve the display label, attached to the button data field,
    ** and change the label string. This automatically redraws the label
    ** because in this program the calculator is always active
    */
    l = (LabelType *)SM_GetButtonData(b);
    SM_SetLabelString(l, currinput);
    return True;
}


/**************************************************************************
**
** EnterOp
**
** Callback function for the calculator operand buttons
*/
int EnterOp(ButtonType *b)
{
    double  currval;
    char    *s;
    LabelType   *l;
    int         i;

    /*
    ** The button label contains the operand symbol
    */
    s = SM_GetButtonLabel(b);

    /*
    ** Convert the current input to a floating point number
    */
    if (strlen(currinput)) {
        currval = atof(currinput);
    }
    else {
        currval = part;
    }

    /*
    ** If a calculation is in progress then combine this value with the
    ** value of the partial result, and store the result in the partial
    ** result global variable; ie.,
    **
    **  part = part (op) currval;
    **
    ** op is the operand entered before this one.
    */
    if (currop != (char)0) {
        if (currop == '+') {
            part = part + currval;
        }
        else if (currop == '-') {
            part = part - currval;
        }
        else if (currop == '*') {
            part = part * currval;
        }
        else if (currop == '/') {
            part = part / currval;
        }
        /*
        ** Convert the partial result to a string and poke it into the
        ** calculator display label
        */
        sprintf(currinput, "%20.8G", part);
        l = (LabelType *)SM_GetButtonData(b);
        SM_SetLabelString(l, currinput);
    }
    else {
        /*
        ** No operations pending; just store the current value
        */
        part = currval;
    }

    /*
    ** Clear the current input string and store this operand
    */
    for (i = 0; i < 80; i++) {
        currinput[i] = (char)0;
    }
    currop = *s;
    return True;
}



/****************************************************************************
**
** CalcResult
**
** Callback function for the calculator's = button
*/
int CalcResult(ButtonType *b)
{
    double      currval;
    LabelType   *l;
    int         i;

    l = (LabelType *)SM_GetButtonData(b);

    /*
    ** If there's no operator stored then the answer is already
    ** calculated, just display it
    */
    if (currop == (char)0) {
        sprintf(currinput, "%20.8G", part);
        SM_SetLabelString(l, currinput);
    }
    else {
        if (!strlen(currinput)) {
            /*
            ** If there's an operator but no current input then the partial
            ** result operates on itself
            */
            currval = part;
        }
        else {
            currval = atof(currinput);
        }
        if (currop == '+') {
            part = part + currval;
        }
        else if (currop == '-') {
            part = part - currval;
        }
        else if (currop == '*') {
            part = part * currval;
        }
        else if (currop == '/') {
            part = part / currval;
        }
        /*
        ** Convert the partial result to a string and poke it into the
        ** calculator display label
        */
        sprintf(currinput, "%20.8G", part);
        l = (LabelType *)SM_GetButtonData(b);
        SM_SetLabelString(l, currinput);
    }
    /*
    ** Clear the input string and operand so entering new numbers
    ** starts a new calculation
    */
    for (i = 0; i < 80; i++) {
        currinput[i] = (char)0;
    }
    currop = (char)0;
    return True;
}


/****************************************************************************
**
** ClearNumbers
**
** Callback function for the calculator's CLEAR button. Erases the
** current number but doesn't affect the current partial result
*/
int ClearNumbers(ButtonType *b)
{
    int i;
    LabelType   *l;

    /*
    ** Erase the current input string by setting the entire array to null
    */
    for (i = 0; i < 80; i++) {
        currinput[i] = (char)0;
    }

    /*
    ** Set the display label to 0
    */
    l = (LabelType *)SM_GetButtonData(b);
    SM_SetLabelString(l, "0");
    currop = (char)0;


    return True;
}


int About(WindowType *w)
{
    WindowType  *about;
    RectType    rt;

    rt.Xmin = 50;
    rt.Ymin = 175;
    rt.Xmax = rt.Xmin + 400;
    rt.Ymax = rt.Ymin + 175;
    about = SM_NewWindow(&rt, "About TWSCalc", DIALOG | NOBACKING, NULL, NULL);
    rt.Xmin = 1;
    rt.Xmax = -999;
    rt.Ymin = -200;
    rt.Ymax = -275;
    SM_CreateLabel(about,&rt,"TWSCALC",NULL,ALIGNCENTER,False,False,False,NULL);
    rt.Ymin = rt.Ymax - 10;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "Simple calculator demo for the TWS Window System",
                   NULL, ALIGNCENTER, False, False, False,NULL);
    rt.Ymin = rt.Ymax - 175;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "Initial Release:",
                   NULL, ALIGNCENTER, False, False, False, NULL);
    rt.Ymin = rt.Ymax - 10;
    rt.Ymax = rt.Ymin - 75;
    SM_CreateLabel(about, &rt,
                   "OCT92",
                   NULL, ALIGNCENTER, False, False, False, NULL);

    rt.Xmin = -400;
    rt.Xmax = -600;
    rt.Ymax = SM_GetContentDepth(about) - 10;
    rt.Ymin = rt.Ymax - 30;
    SM_CreateButton(about,
                    &rt,
                    "OK",
                    NULL,
                    CloseAbout);
    SM_OpenWindow(about);
}


int CloseAbout(ButtonType *b)
{
    SM_CloseWindow(SM_GetGadgetWindow(b));
    return True;
}


int CalcExit(WindowType *w)
{
    SM_CloseAllWindows();
    SM_Exit(w);
}


int HowItWorks(WindowType *w)
{
    WindowType  *works;
    RectType    rt;
    TextboxType *tb;

    rt.Xmin = rt.Ymin = 150;
    rt.Xmax = rt.Xmin + 500;
    rt.Ymax = rt.Ymin + 350;
    works = SM_NewWindow(&rt, "Calc.c", DOCUMENT | NOBACKING, NULL, NULL);
    rt.Xmin = rt.Ymin = 1;
    rt.Xmax = SM_GetContentWidth(works) - 2;
    rt.Ymax = SM_GetContentDepth(works) - 2;
    tb = SM_CreateTextbox(works,
                          &rt,
                          "calc.c",
                          SM_GetSystemFont(),
                          True,
                          False,
                          NULL);
    SM_SetResizeProc(works, ResizeText);
    SM_SetUserData(works, (void *)tb);
    SM_OpenWindow(works);
}


int ResizeText(WindowType *w)
{
    TextboxType *tb;
    RectType    rt;

    tb = (TextboxType *)SM_GetUserData(w);
    rt.Xmin = rt.Ymin = 1;
    rt.Xmax = SM_GetContentWidth(w) - 2;
    rt.Ymax = SM_GetContentDepth(w) - 2;
    SM_SetTextboxRect(tb, &rt);
}


