//
// TVSERIAL.H
//

const int cmAboutBox = 100;             // Command list.
const int cmComSetup = 101;
const int cmTerminal = 102;


class TTermView : public TTerminal {

public:

    TTermView( const TRect& bounds,
               TScrollBar *aHScrollBar,
               TScrollBar *aVScrollBar );
    ~TTermView();
    virtual void handleEvent( TEvent& event );
    virtual void draw(void);
    virtual Boolean valid(ushort command) { return successFlag; }
    virtual int do_sputn( const char *s, int count );
    virtual void do_sputc( const char c );

    void update();
    static TTermView *instance;

private:

    Boolean successFlag;

//    TComPort *device;

};


class TTermWindow : public TWindow
{
public:
    TTermWindow();
};


class tvserial : public TApplication
{

public:

    tvserial();
    void idle()
        {
        heap->update();
        if( TTermView::instance != 0 )
            TTermView::instance->update();
        }
    void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect r );

private:

    THeapView *heap;

    void aboutDlgBox();
    void terminal();
    void comSetup();

};

