//
// SETUP.CPP - code for communication setup dialog box.
//

#define Uses_TRadioButtons
#define Uses_TLabel
#define Uses_TButton
#define Uses_TSItem
#define Uses_TView
#define Uses_TRect
#define Uses_TInputLine
#define Uses_TDialog
#define Uses_TEvent
#include <tv.h>

#include <ctype.h>
#pragma hdrstop

#include "serial.h"
#include "setup.h"

class TBitLine : public TInputLine
{

public:

    TBitLine(TRect& bounds, int aMaxLen, char low = '0', char high = '9') :
        TInputLine(bounds, aMaxLen)
    {
        lowDigit = low; highDigit = high;
    }
    virtual void handleEvent(TEvent& event);

private:

    char lowDigit, highDigit;

};

void TBitLine::handleEvent(TEvent& event)
{
    char key = event.keyDown.charScan.charCode;

    if( !(event.what == evKeyboard && isprint(key) &&
          (key < lowDigit || key > highDigit)) )
        TInputLine::handleEvent(event);
}


int comData::getBaud()
{
    switch(baudRate)
    {
    case B300:
        return 300;
    case B1200:
        return 1200;
    case B2400:
        return 2400;
    }
    return 0;       // Useless Baudrate.
}

int comData::getParity()
{
    switch(parity)
    {
    case P_EVEN:
        return(EVEN_PARITY);
    case P_ODD:
        return(ODD_PARITY);
    case P_NONE:
        return(NO_PARITY);
    }
    return(-1);     // Invalid parity -- 0 is None so we can't use that.
}


TSetupDialog::TSetupDialog() :
    TDialog( TRect(0, 0, 43, 14), "Communication Setup" ),
    TWindowInit( initFrame )
{
    TView *control = new TRadioButtons( TRect(3,3,13,6),
                       new TSItem("300",
                       new TSItem("1200",
                       new TSItem("2400", 0)))
                     );
    insert(control);
    insert( new TLabel( TRect(3,2,13,3),"~B~aud Rate", control) );

    control = new TRadioButtons( TRect(16,3,27,5),
                new TSItem("COM 1",
                new TSItem("COM 2",0))
              );
    insert(control);
    insert( new TLabel( TRect(16,2,21,3), "~P~ort", control) );

    control = new TRadioButtons( TRect(30,3,40,6),
                new TSItem("Even",
                new TSItem("Odd",
                new TSItem("None",0)))
              );
    insert(control);
    insert( new TLabel( TRect(31,2,38,3), "P~a~rity", control) );

    control = new TBitLine( TRect(15,8,19,9), 2, '0', '2');
    insert(control);
    insert( new TLabel( TRect(3,8,14,9), "~S~top Bits:", control) );

    control = new TBitLine( TRect(15,10,19,11), 2, '5', '8');
    insert(control);
    insert( new TLabel( TRect(3,10,14,11), "~D~ata Bits:", control) );

    insert( new TButton( TRect(24,8,34,10), "~O~K", cmOK, bfDefault) );
    insert( new TButton( TRect(24,11,34,13), "~C~ancel", cmCancel, bfNormal) );
    selectNext( False );
}
