//------------------------------------------------------------------------
//
// Turbo Vision Serial Communications Example
//
//------------------------------------------------------------------------

#define Uses_TKeys
#define Uses_TRect
#define Uses_TEvent
#define Uses_TButton
#define Uses_TDialog
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStaticText
#define Uses_TDeskTop
#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TScroller
#define Uses_TTerminal
#include <tv.h>

#include <iostream.h>
#include <fstream.h>
#include <strstrea.h>
#include <string.h>
#include <ctype.h>
#include <gadgets.h>
#pragma hdrstop

#include <conio.h>
#include <ctype.h>

#include "tvserial.h"
#include "serial.h"
#include "setup.h"

extern "C"
{
    int getccb(void);
    int setSerial(int port, int speed, int parity, int bits, int stopBit);
    int serialOut(char byte);
    void initSerial(void);
    void closeSerial(void);
}
extern int SError;


comData settings(B2400, COM2, P_NONE, 1, 8);

#define INTRO "Turbo Vision Serial Communications Example\n...You're now in terminal mode...\n\n"

void main(void)
{
    tvserial terminal;

    terminal.run();
}


//
// ---------------- Functions for class "tvserial" -----------------------
//
tvserial::tvserial() :
    TProgInit( initStatusLine,
               initMenuBar,
               initDeskTop)
{
    TRect r = getExtent();
    r.a.y = r.b.y - 1;
    r.a.x = r.b.x - 13;
    heap = new THeapView( r );
    insert( heap );
}

TMenuBar *tvserial::initMenuBar( TRect r )
{
    r.b.y =  r.a.y + 1;

    return (new TMenuBar( r,
        *new TSubMenu( "~W~hy?", kbNoKey ) +
            *new TMenuItem( "~A~bout...", cmAboutBox, kbNoKey ) +

            *new TMenuItem( "~S~ettings...", cmComSetup, kbNoKey ) +
            *new TMenuItem( "~T~erminal", cmTerminal, kbNoKey ) +
             newLine() +
            *new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X" )
        )
    );
}

void tvserial::handleEvent( TEvent& event )
{
    TApplication::handleEvent(event);

    if (event.what == evCommand)
        {
        switch (event.message.command)
            {
            case cmAboutBox:
                aboutDlgBox();
                break;
            case cmComSetup:
                comSetup();
                break;
            case cmTerminal:
                terminal();
                break;
            }
        }
}


void tvserial::aboutDlgBox()
{
    TDialog *aboutBox = new TDialog(TRect(0, 0, 39, 13), "About");

    aboutBox->insert(
      new TStaticText(TRect(1, 2, 38, 9),
        "\003Turbo Vision\n"
        "\003Serial Communications\n"
        "\003Example\n \n"                    
        "\003Copyright (c) 1991\n \n"         
        "\003Borland International"
        )
    );

    aboutBox->insert(
      new TButton(TRect(14, 10, 25, 12), " OK", cmOK, bfDefault)
    );

    aboutBox->options |= ofCentered;
    deskTop->execView(aboutBox);

    destroy(aboutBox);
}


void tvserial::terminal()
{
    TTermWindow *t = (TTermWindow *) validView( new TTermWindow() );
    if( t != 0 )
        deskTop->insert( t );
}

void tvserial::comSetup()
{
    TSetupDialog *t = (TSetupDialog *) validView( new TSetupDialog() );

    if( t != 0 )
    {
        t->options |= ofCentered;
        t->setData( (void *) &settings);
        if( deskTop->execView( t ) != cmCancel )
            t->getData( (void *) &settings);
    }

    destroy(t);
}


//
// TTermWindow functions
//
TTermWindow::TTermWindow() :
    TWindow( TProgram::deskTop->getExtent(), "So Red the Rose", 1 ),
    TWindowInit( initFrame )
{
    TRect r( getExtent() );
    r.grow(-1, -1);
    options |= ofTileable;
    TTermView *t = new TTermView( r,
                         standardScrollBar(sbHorizontal | sbHandleKeyboard),
                         standardScrollBar(sbVertical | sbHandleKeyboard)
                       );
    if( t != 0 )
        insert(t);
}


TTermView *TTermView::instance;

void TTermView::update()
{
    int c;

    if( instance != 0 &&
        (c = getccb()) != -1 &&
        c != '\n' && c != '\f' && c != '\0'
      )
    {
        if( c == '\r' )
            c = '\n';
        instance->do_sputc( (char) c );
        instance->drawView();
    }
}


TTermView::TTermView( const TRect& bounds,
                      TScrollBar *aHScrollBar,
                      TScrollBar *aVScrollBar
                    ) :
    TTerminal( bounds, aHScrollBar, aVScrollBar, 32768U )
{
    successFlag = True;

    if( instance != 0 )
    {
        messageBox("Already have a terminal open.", mfOKButton);
        successFlag = False;
    }
    else
        instance = this;

    if(setSerial(settings.getComPort(), settings.getBaud(),
                 settings.getParity(), settings.getDataBits(),
                 settings.getStopBits()) != 0)
    {
        messageBox("Serial Port setup error.", mfOKButton);
        successFlag = False;
    }

    initSerial();

    do_sputn( INTRO, strlen(INTRO) );
}

TTermView::~TTermView()
{
//    char buf[64];

    instance = 0;

    switch (SError)
    {
        case NOERROR:
//            do_sputn("\nbye.\n", 6);
//            drawView();
            break;
        case BUFOVFL:
//            do_sputn("\nBuffer Overflow.\n", 18);
//            drawView();
            break;
        default:
//            ostrstream(buf, sizeof(buf)) << "\nUnknown Error, SError = " << SError << '\n' << ends;
//            do_sputn(buf, strlen(buf));
//            drawView();
            break;
    }
    closeSerial();
}

void TTermView::handleEvent( TEvent& event )
{
    TTerminal::handleEvent( event );

    if( event.what == evKeyboard &&
        event.keyDown.charScan.charCode != 0 &&
        isascii( event.keyDown.charScan.charCode )
      )
    {
        serialOut( event.keyDown.keyCode );
        clearEvent( event );
    }
}

void TTermView::draw()
{
    short  i;
    ushort begLine, endLine;
    char s[256];
    ushort bottomLine;

    bottomLine = size.y + delta.y;
    if( limit.y > bottomLine )
    {
        endLine = prevLines( queFront, limit.y - bottomLine );
        bufDec( endLine );
    }
    else
        endLine = queFront;

    if( limit.y > size.y )
        i = size.y - 1;
    else
    {
        for( i = limit.y; i <= size.y - 1; i++ )
            writeChar(0, i, ' ', 1, size.x);
        i =  limit.y -  1;
    }

    for( ; i >= 0; i-- )
    {
        begLine = prevLines(endLine, 1);
        if (endLine >= begLine)
        {
            int T = (int) (endLine - begLine);
            memcpy( s, &buffer[begLine], T );
            s[T] = EOS;
        }
        else
        {
            int T = (int) (bufSize - begLine);
            memcpy( s, &buffer[begLine], T );
            memcpy( s+T, buffer, endLine );
            s[T+endLine] = EOS;
        }
        if( delta.x >= strlen(s) )
            *s = EOS;
        else
            strcpy( s, &s[delta.x] );

        writeStr( 0, i, s, 1 );
        writeChar( strlen(s), i, ' ', 1, size.x );
        endLine = begLine;
        bufDec( endLine );
    }
}


void TTermView::do_sputc( const char c )
{
    ushort screenLines = limit.y;
    int i;

    if( c == '\n' )
        screenLines++;

    if( !canInsert( 1 ) )
    {
        queBack = nextLine( queBack );
        screenLines--;
    }

    if( c != '\x08' )
    {
        buffer[queFront++] = c;
        if( queFront == bufSize )
            queFront = 0;
    }
    else if( queFront != queBack )
    {
        --queFront;
        if( (int) queFront < 0 )
            queFront += bufSize;
        if( buffer[queFront] == '\n' )
            --screenLines;
    }

    ++drawLock;
    setLimit( limit.x, screenLines );
    scrollTo( 0, screenLines + 1 );
    --drawLock;

    i = prevLines( queFront, 1 );
    if( i <= queFront )
        i = queFront - i;
    else
        i = bufSize - (i - queFront);
    setCursor( i, screenLines - delta.y - 1 );
    return;
}


int TTermView::do_sputn( const char *s, int count )
{
    ushort screenLines = limit.y;
    for( ushort i = 0; i < count; i++ )
        if( s[i] == '\n' )
            screenLines++;

    while( !canInsert( count ) )
        {
        queBack = nextLine( queBack );
        screenLines--;
        }

    if( queFront + count >= bufSize )
        {
        i = bufSize - queFront;
        memcpy( &buffer[queFront], s, i );
        memcpy( buffer, &s[i], count - i );
        queFront = count - i;
        }
    else
        {
        memcpy( &buffer[queFront], s, count );
        queFront += count;
        }

    ++drawLock;
    setLimit( limit.x, screenLines );
    scrollTo( 0, screenLines + 1 );
    --drawLock;

    i = prevLines( queFront, 1 );
    if( i <= queFront )
        i = queFront - i;
    else
        i = bufSize - (i - queFront);
    setCursor( i, screenLines - delta.y - 1 );
    return count;
}

