//
// SETUP.H - setup dialog box for communication settings.
//

#define B300    0x00
#define B1200   0x01
#define B2400   0x02

#define P_EVEN  0x00
#define P_ODD   0x01
#define P_NONE  0x02

class comData
{

public:

    comData(unsigned baud = B2400,
            unsigned port = COM2,
            unsigned parit = P_NONE,
            unsigned char stop = 1,
            unsigned char data = 8)
    {
        baudRate = baud;
        comPort = port - 1;
        parity = parit;
        stopBits[0] = stop + '0';
        dataBits[0] = data + '0';
        stopBits[1] = dataBits[1] = '\0';
    }

    int getBaud();
    int getComPort() { return(comPort+1); }
    int getParity();
    char getStopBits() { return(stopBits[0] - '0'); }
    char getDataBits() { return(dataBits[0] - '0'); }

private:

    unsigned baudRate, comPort, parity;
    unsigned char stopBits[2], dataBits[2];

};

class TSetupDialog : public TDialog
{

public:

    TSetupDialog();

};

