//
// PALETTE.H
//
// Copyright (c) 1992 CC Software
// All rights reserved
//
// Class TStreamPalette : Streamable TPalette object
//

#if !defined( __TVPAL_H )
#define __TVPAL_H

// Interface Dependencies ---------------------------------------------
//

#define Uses_TPalette
#define Uses_TStreamable
#define Uses_TStreamableClass
#include <tv.h>

//
// END Interface Dependencies -----------------------------------------


// Class TStreamPalette //

// Description --------------------------------------------------------
//
//      Joins the functionality of the TStreamable and TPalette to create
//      streamable Palette objects.
//
// Member Functions
//
//      read( ipstream& )
//
//      Reads the palette from the given input source stream.
//
//      write( opstream& )
//
//      Writes the palette to the given sink stream.
//
//      build()
//
//      Creates a TStreamPalette object by reading it from the given
//      input stream.
//
//      streamableName()
//
//      Returns the name of the class TStreamPalette
//
//
// Inherited Member Functions
//
//      operator =( const TPalette& )
//
//      operator []( int index )
//
// END Description ====================================================

class TStreamPalette : public TPalette, public TStreamable {
public:
       TStreamPalette( const char _FAR* bytes, ushort len );
       TStreamPalette( const TPalette _FAR& );

       static char _FAR* name;
       static TStreamable _FAR* build();

protected:
       TStreamPalette( StreamableInit );
       virtual void write( opstream _FAR& );
       virtual void _FAR* read( ipstream _FAR& );

private:
       virtual const char _FAR* streamableName() const { return name; };
};
// END TStreamPalette =================================================



// TStreamable Inline Member functions //

// Constructor //

inline TStreamPalette::TStreamPalette( const char *bytes, ushort len ) :
         TPalette( bytes, len )
// Summary ------------------------------------------------------------
//
//      Creates the TStreamPalette instance based on the data string
//      and length of that string.
//
// Parameters
//
//      bytes
//
//      Pointer to a char string (possible nulls inside) containing
//      the palette entries.
//
//      len
//
//      The overall length of the palette "string."
//
// END Summary --------------------------------------------------------
{
};
// END TStreamPalette::TStreamPalette ---------------------------------



// Constructor //

inline TStreamPalette::TStreamPalette( const TPalette _FAR& p ) :
         TPalette( p )
// Summary ------------------------------------------------------------
//
//      Again, here we have a constructor to copy a TPalette derived
//      class.  This is made specially for TPalette copying into
//      TStreamPalette streamable objects.
//
// Parameters
//
//      p
//
//      A TPalette derived class for creating TStreamPalette instances
//      from TPalette instances.
//
// END Summary --------------------------------------------------------
{
};
// END TStreamPalette::TStreamPalette ---------------------------------



// Protected Constructor //

inline TStreamPalette::TStreamPalette( StreamableInit ) :
         TPalette( NULL, 0 )
// Summary ------------------------------------------------------------
//
//      Build constructor for a TStreamPalette.  Since we don't yet
//      know what the palette entries are we won't reserve any memory
//      for them.
//
// END Summary --------------------------------------------------------
{
};
// END TStreamPalette::TStreamPalette ---------------------------------



// Stream Inserters and Extractors //

inline ipstream&  operator >> ( ipstream& is, TStreamPalette& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TStreamPalette*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TStreamPalette& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TStreamPalette* cl )
    { return os << (TStreamable *)cl; }

#endif // __TVPAL_H