//
// PALETTE.CPP
//
// Copyright (c) 1992 CC Software
// All rights reserved
//

// Contents ===========================================================
//
//      TStreamPalette::read
//      TStreamPalette::write
//      TStreamPalette::build
//
// Description
//
//      TStreamPalette non-inline member functions
//
// END Contents =======================================================

#include "TVPal.h"


// Stream Registration Records //

TStreamableClass RStreamPalette(
                   TStreamPalette::name,
                   TStreamPalette::build,
                   __DELTA(TStreamPalette)
                 );


// Static Class Data //

char _FAR* TStreamPalette::name = "TStreamPalette";


// Member Function //

TStreamable _FAR* TStreamPalette::build()
// Summary ------------------------------------------------------------
//
//      Returns a "dumb" TStreamPalette object to be filled from a
//      stream read.
//
// END Summary --------------------------------------------------------
{
  return new TStreamPalette( streamableInit );
};
// END TStreamPalette::build ------------------------------------------



// Member function //

void TStreamPalette::write( opstream _FAR& os )
// Summary ------------------------------------------------------------
//
//      Writes the object to the stream.  We first write the palette
//      length (which is stored in the zero index), then the actual
//      palette entries.
//
// Parameters
//
//      os
//
//      An opstream derived class to write on.
//
// END Summary --------------------------------------------------------
{
  ushort len = operator[](0);
  os.writeBytes( &len, sizeof(len) );

  if ( len )
     os.writeBytes( &(operator[](1)), len );
};
// END TStreamPalette::write ------------------------------------------



// Member function //

void *TStreamPalette::read( ipstream _FAR& is )
// Summary ------------------------------------------------------------
//
//      Reads the palette in from the stream.  The actual stream object
//      is first read into a data buffer, then the convenient operator=
//      for the TPalette is called on the (*this) operator to assign the
//      bytes to this object.
//
// Parameters
//
//      is
//
//      Input stream we are reading the bytes from.
//
// Return Value
//
//      Returns this.
//
// END Summary --------------------------------------------------------
{
  TPalette *tp;
  ushort len = 0;
  char *data = NULL;

  is.readBytes( &len, sizeof(len) );
  if ( len )
  {
    data = new char[ len ];
    is.readBytes( data, len );
    tp = new TPalette( data, len );
    *this = *tp;
    delete data;
    delete tp;
  };
  return this;
};
// END TStreamPalette::read -------------------------------------------