
  /*********************************************************************
   *                                                                   *
   * MDLG.CPP                                                          *
   *   This module contains the code for the two subclassed dialogs use*
   *   by this demo.                                                   *
   *                                                                   *
   * SUPPORT MODULE for dialog example #3 : Creating a second modal    *
   *   dialog box from within a first.                                 *
   *                                                                   *
   *   The key to this operation is making sure that the deskTop's     *
   *   execView() function is used in all cases when a modal dialog box*
   *   is desired.  execView() is a member function of TGroup, thus any*
   *   class derived from TGroup will have its own version of that     *
   *   function.  When inside a dialog box handleEvent procedure, code *
   *   such as                                                         *
   *                                                                   *
   *      TDialog *td = ...                                            *
   *      execView( td );                                              *
   *                                                                   *
   *   will compile, but the box will come up with lots of flashing    *
   *   white on red colors.  This is because the new dialog box was    *
   *   inserted into the old dialog box, instead of the deskTop and the*
   *   palette isn't mapped right.  The solution is to execView the    *
   *   dialog box this way:                                            *
   *                                                                   *
   *      TDialog *td = ...                                            *
   *      TProgram::deskTop->execView( td );                           *
   *                                                                   *
   *  'deskTop' is a static public member of TProgram and points to the*
   *   desktop object of the current application.  This way, the dialog*
   *   box will be inserted into the desktop and the palettes will work*
   *   properly.  The Z order will also be correct so that the views   *
   *   stack up right.                                                 *
   *                                                                   *
   *********************************************************************
   *                                                                   *
   * This code was written by Borland Technical Support.               *
   * It is provided as is with no warranties expressed or implied.     *
   *                                                                   *
   *********************************************************************/

  #define Uses_TRect
  #define Uses_TKeys

  #define Uses_TEvent
  #define Uses_TButton
  #define Uses_TStaticText
  #define Uses_TDialog
  #define Uses_MsgBox
  #define Uses_TDeskTop
  #define Uses_TProgram
  #include <tv.h>

  #pragma hdrstop

  #include "cmds.h"
  #include "mdlg.h"


  /********************************************************************
   *   Class TFirstDialog                                             *
   ********************************************************************
   * TFirstDialog::TFirstDialog                                       *
   *   Constructor for the dialog box.  Encapsulates the box to ease  *
   *   creation.                                                      *
   ********************************************************************/

  TFirstDialog::TFirstDialog( TRect& r, char *aTitle ) :
      TDialog( r, aTitle ),
      TWindowInit( initFrame )
  {
      insert( new TStaticText( TRect(2,2,38,6),
         "This is a modal dialog box.  Hitting the <More> button below "
         "will bring up a second modal dialog box on top of this one."
          ));

      insert( new TButton( TRect(2,8,12,10),
                          "~M~ore", cmMore, bfDefault )
            );
      insert( new TButton( TRect(14,8,24,10), "O~K~", cmOK, bfNormal )
            );
      insert( new TButton( TRect(26,8,36,10), "~C~ancel", cmCancel,
                           bfNormal )
            );

      selectNext( False );
      options |= ofCentered;


  }


  /***********************************************************************
   * TFirstDialog::handleEvent
   *   Handle the <More> button and bring up the second dialog box when
   *   this button is pushed.
   ***********************************************************************/

  void TFirstDialog::handleEvent( TEvent& event )
  {
      TSecondDialog *td;

      if( event.what == evCommand )
          switch( event.message.command )
          {
          case cmMore:               // Brings up a second dialog box...
              td = new TSecondDialog( TRect(0,0,38,9),
                                      "The second dialog box."
                                    );
              if( TProgram::application->validView( td ) )
                  TProgram::deskTop->execView( td );
              clearEvent( event );
              break;
          }

      TDialog::handleEvent( event );
  }


  /**********************************************************************
   *
   * Class TSecondDialog
   *
   **********************************************************************
   * TSecondDialog::TSecondDialog
   *   A fairly cheezy second dialog box with an ok button to make it go
   *   away.  (This is probably a good thing :-) )
   ***********************************************************************/

  TSecondDialog::TSecondDialog( TRect& r, char *aTitle ) :
      TDialog( r, aTitle ),
      TWindowInit( initFrame )

  {
      insert( new TStaticText( TRect(2,2,36,5),
        "This the second modal dialog box.  Hitting the <OK> button or "
        "<Esc> will make it go away."
          ));

      insert( new TButton( TRect(13,6,23,8), "O~K~", cmOK, bfDefault )
            );
      options |= ofCentered;
  }

