#define Uses_TDialog
#define Uses_TStaticText
#define Uses_TButton
#define Uses_TView
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TDeskTop
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TKeys
#include <tv.h>
#include "TLScrlb.h"
#include <bengine.h>
#include <bdatabas.h>
#include <brecord.h>
#include <bcursor.h>
#include <stdio.h>

// ------------------------------------------------------------------
// dialog commands.
const cmNextRec = 100,
	  cmPrevRec = 101;

// The dialog class.
class TDBDialog : public TDialog
	{
	public:

		TDBDialog(BCursor*);

		virtual void handleEvent(TEvent&);

		void update();

	protected:

		BCursor* cursor;
		TLongScrollBar* sb;
		TStaticText* recNr;
		TStaticText* name;
		TStaticText* address;
		TStaticText* age;
		TStaticText* dob;
		TStaticText* weight;
		TButton* nextBtn;
		TButton* prevBtn;
	};

TDBDialog::TDBDialog(BCursor* pCursor) :
		TDialog(TRect(4,2,75,17), "Database Record"),
		TWindowInit(initFrame),
		cursor(pCursor),
		recNr(0), name(0), address(0), age(0), dob(0), weight(0)
	{
	TView* control;

	options |= ofCentered;		// make it centered within the desktop.
	eventMask |= evBroadcast;   // so it accepts evBroadcast events.

	// Insert the 'labels'.
	control = new TStaticText(TRect(3,2,11,3), "Record#:");
	insert(control);

	control = new TStaticText(TRect(3,4,8,5), "Name:");
	insert(control);

	control = new TStaticText(TRect(3,5,11,6), "Address:");
	insert(control);

	control = new TStaticText(TRect(3,6,7,7), "Age:");
	insert(control);

	control = new TStaticText(TRect(3,7,17,8), "Date of birth:");
	insert(control);

	control = new TStaticText(TRect(3,8,10,9), "Weight:");
	insert(control);

	// Insert the buttons.
	nextBtn = new TButton(TRect(11,11,23,13), "~N~ext", cmNextRec, bfNormal);
	insert(nextBtn);

	prevBtn = new TButton(TRect(27,11,39,13), "~P~rev", cmPrevRec, bfNormal);
	insert(prevBtn);

	control = new TButton(TRect(43,11,55,13), "~C~ancel", cmCancel, bfDefault);
	insert(control);

	sb = new TLongScrollBar(TRect(70,1,71,14));
	sb->options |= ofPostProcess; // so it uses cursor keys.
	insert(sb);

	selectNext(False);

	// Set the scrollbar's range.
	long rng = cursor->getRecCount();
	if(cursor->lastError == PXSUCCESS);
		sb->setRange(0,rng-1);
	// And update() to the first record.
	update();
	}

void TDBDialog::handleEvent(TEvent& event)
	{
	TDialog::handleEvent(event);

	// Handle button presses.
	if(event.what == evCommand)
		{
		if(event.message.command == cmNextRec)
			{
			sb->setValue(sb->value+1);
			clearEvent(event);
			}
		else if(event.message.command == cmPrevRec)
			{
			sb->setValue(sb->value-1);
			clearEvent(event);
			}
		}

	// Handle a change in the scrollbar.
	else if(event.what == evBroadcast &&
			event.message.command == cmScrollBarChanged &&
			event.message.infoPtr == sb)
		update();
	}

void TDBDialog::update()
	{
	BOOL fNull;
	char avalue[51];
	BDate dvalue;
	INT16 svalue;
	double dblvalue;

	// Remove existing views.
	destroy(recNr);
	destroy(name);
	destroy(address);
	destroy(age);
	destroy(dob);
	destroy(weight);
	recNr = name = address = age = dob = weight = 0;

	// Update the rec nr.
	sprintf(avalue, "%ld", sb->value+1);
	recNr = new TStaticText(TRect(18,2,28,3), avalue);
	insert(recNr);

	// Read the data in from the database and create new views.
	if(cursor->gotoRec(sb->value+1) == PXSUCCESS &&
					 cursor->getRecord() == PXSUCCESS)
		{
		// Get the name.
		cursor->genericRec->getField(1, avalue, 51, fNull);
		name = new TStaticText(TRect(18,4,68,5), avalue);
		insert(name);
		// Get the address.
		cursor->genericRec->getField(2, avalue, 51, fNull);
		address = new TStaticText(TRect(18,5,68,6), avalue);
		insert(address);
		// Get the age.
		cursor->genericRec->getField(3, svalue, fNull);
		if(fNull)	svalue = 0;
		sprintf(avalue, "%3d", svalue);
		age = new TStaticText(TRect(18,6,21,7), avalue);
		insert(age);
		// Get the Date of Birth.
		cursor->genericRec->getField(4, dvalue, fNull);
		if(fNull)	dvalue.month = dvalue.day = dvalue.year = 0;
		sprintf(avalue, "%2d/%2.2d/%2.2d", dvalue.month, dvalue.day, dvalue.year%100);
		dob = new TStaticText(TRect(18,7,26,8), avalue);
		insert(dob);
		// Get the weight.
		cursor->genericRec->getField(5, dblvalue, fNull);
		if(fNull)	dblvalue = 0.0;
		// and round it.
		svalue = dblvalue;
		sprintf(avalue, "%3d", svalue);
		weight = new TStaticText(TRect(18,8,21,9), avalue);
		insert(weight);
		}

	// disable/enable appropriate commands.
	if(sb->value <= sb->minVal)
		{
		// If the prev button has the focus, move it.
		if((prevBtn->state & sfFocused) != 0)
			selectNext(False);
		// and disable it.
		disableCommand(cmPrevRec);
		}
	else
		enableCommand(cmPrevRec);
	if(sb->value >= sb->maxVal)
		{
		// If the next button has the focus, move it.
		if((nextBtn->state & sfFocused) != 0)
			selectNext(False);
		// and disable it.
		disableCommand(cmNextRec);
		}
	else
		enableCommand(cmNextRec);
	}

// ---------------------------------------------------------------------

const cmViewTable = 100;
const char* tblName = "Table2";

class TEngAppInit
	{
	public:
		TEngAppInit(BEngine* (*fn)()) : createEngine(fn)	{}
	protected:
		BEngine* (*createEngine)();
	};

class TApp : public TApplication, virtual public TEngAppInit
	{
	public:

		TApp();

		virtual void shutDown();
		virtual Boolean valid(ushort);
		virtual void handleEvent(TEvent&);

		static TMenuBar* initMenuBar(TRect);
		static BEngine* initEngine();

		static BEngine* engine;
		static BDatabase* database;
	protected:

		Boolean status;
	};

BEngine* TApp::engine = 0;
BDatabase* TApp::database = 0;

TApp::TApp() :
		TProgInit(initStatusLine,initMenuBar,initDeskTop),
		TEngAppInit(initEngine)
	{
	if(createEngine != 0)
		engine = createEngine();
	status = Boolean(engine != 0 && engine->lastError == PXSUCCESS);
	if(status)
		if(!engine->isOpen)
			status = Boolean(engine->open() == PXSUCCESS);
	if(status)
		{
		database = new BDatabase(engine);
		status = Boolean(database->lastError == PXSUCCESS);
		}
	}

void TApp::shutDown()
	{
	delete database;
	delete engine;
	TApplication::shutDown();
	}

Boolean TApp::valid(ushort cmd)
	{
	if(cmd == cmValid && !status)
		return False;
	else
		return TApplication::valid(cmd);
	}

void TApp::handleEvent(TEvent& event)
	{
	TApplication::handleEvent(event);

	if(event.what == evCommand && event.message.command == cmViewTable)
		{
		BCursor* cursor = new BCursor(database, tblName);
		if(cursor->lastError == PXSUCCESS)
			{
			TDialog* dlg = new TDBDialog(cursor);
			if(validView(dlg) != 0)
				{
				deskTop->execView(dlg);
				destroy(dlg);
				}
			}
		delete cursor;
		clearEvent(event);
		}
	}

TMenuBar* TApp::initMenuBar(TRect r)
	{
	r.b.y = r.a.y+1;
	return new TMenuBar(r,
		*new TSubMenu("~F~ile", 0)+
			*new TMenuItem("~V~iew table...", cmViewTable, kbNoKey, hcNoContext, 0)+
			newLine()+
			*new TMenuItem("E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X")
		);
	}

BEngine* TApp::initEngine()
	{
	return new BEngine(pxLocal);
	}

int main()
	{
	TApp app;

	if(app.valid(cmValid))
		app.run();
	app.shutDown();
	return 0;
	}
