// File    : TVCOLR.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Sat 07/23/94 14:07:54
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// Easy extensions to the colors for Turbo Vision applications.
// Complete documentation for this method can be found by downloading
// TVCLR2.ZIP from the BCPPDOS forum of CompuServe.
//
// This copy contains fewer comments on how to add extended colors so
// that you can get an uncluttered view of how it works.
// See TVCOLR.HDC for a fully commented view of how it works.
//
// NOTE: If you modify this file, modify TVCOLR.HDC accordingly!!
//

#if !defined( __TVCOLR_H )
#define __TVCOLR_H

#if !defined(cpAppColor)
#define  Uses_TProgram
#include <tvision\tv.h>             // Get the standard colors defined.
#endif

#if !defined(cHelpViewer)
class _FAR fpstream;
#include <tvision\helpbase.h>       // Get the help palette indices defined.
#endif

// An alternate color palette attributes map.
// I have added nine colors (two to TButton and one to TLabel for each of the
// three dialog palettes) that the default Turbo Vision doesn't have for when
// those objects are focused.  If the definition MODIFIED_TV_COLORS appears
// in APP.H, then those six extra colors will be defined here too.

#if defined(MODIFIED_TV_COLORS)

#define cpAppAltColor \
    "\x07\x70\x74\x76\x17\x18\x1B\x07\x03\x0B\x70\x70\x07\x70" \
    "\x1F\x37\x3F\x3A\x13\x13\x3F\x1F\x3F\x70\x7F\x7A\x13\x13" \
    "\x70\x7F\x7E\x70\x7F\x7A\x13\x13\x70\x70\x6F\x7E\x1B\x1F" \
    "\x6F\x18\x1E\x70\x30\x3F\x3E\x1B\x6F\x1A\x20\x70\x07\x70" \
    "\x30\x1B\x3E\x31\x13\x38\x00\x17\x1F\x1A\x71\x71\x1E\x17" \
    "\x6F\x1E\x3B\x3F\x6F\x38\x3F\x10\x30\x3F\x3E\x70\x2F\x7A" \
    "\x20\x12\x31\x31\x30\x2F\x3E\x31\x13\x38\x00\x37\x3F\x3A" \
    "\x13\x13\x3E\x30\x6F\x3E\x1B\x1F\x6F\x18\x1E\x30\x70\x7F" \
    "\x7E\x1F\x2F\x1A\x20\x32\x31\x71\x70\x2F\x7E\x71\x13\x38\x00" \
    "\x67\x6F\x6E\x76\x76\x6F\x6E\x1E" \
    "\x1D\x6E\x6E\x3E\x6E\x6E\x1D\x6E\x6E"  // Extra button & label colors
#else

#define cpAppAltColor \
    "\x07\x70\x74\x76\x17\x18\x1B\x07\x03\x0B\x70\x70\x07\x70" \
    "\x1F\x37\x3F\x3A\x13\x13\x3F\x1F\x3F\x70\x7F\x7A\x13\x13" \
    "\x70\x7F\x7E\x70\x7F\x7A\x13\x13\x70\x70\x6F\x7E\x1B\x1F" \
    "\x6F\x18\x1E\x70\x30\x3F\x3E\x1B\x6F\x1A\x20\x70\x07\x70" \
    "\x30\x1B\x3E\x31\x13\x38\x00\x17\x1F\x1A\x71\x71\x1E\x17" \
    "\x6F\x1E\x3B\x3F\x6F\x38\x3F\x10\x30\x3F\x3E\x70\x2F\x7A" \
    "\x20\x12\x31\x31\x30\x2F\x3E\x31\x13\x38\x00\x37\x3F\x3A" \
    "\x13\x13\x3E\x30\x6F\x3E\x1B\x1F\x6F\x18\x1E\x30\x70\x7F" \
    "\x7E\x1F\x2F\x1A\x20\x32\x31\x71\x70\x2F\x7E\x71\x13\x38\x00" \
    "\x67\x6F\x6E\x76\x76\x6F\x6E\x1E"      // Alternate help colors
#endif

// Define any other palette names and the total number of available palettes.
// For additional palettes, start numbering them at 3.  They must come
// after the regular color, black and white, and monochrome sets because
// apColor, apBlackWhite, and apMonochrome are defined as 0 through 2.
#define apAltColor         3        // Alternate color palette.

#define apTotalPalettes    4        // Color, B&W, Monochrome, Alt. Color.

// Define the default extended color sets
//
// If the default TV colors have not been modified as described in
// COLUPDT.DOC, some padding is added so that the indices below come out
// the same regardless of this optional change.
//
#if defined(MODIFIED_TV_COLORS)

#define cpDefAltColor       cpAppAltColor
#define cpDefColor          cpAppColor
#define cpDefBlackWhite     cpAppBlackWhite
#define cpDefMonochrome     cpAppMonochrome

#else

#define cpDefAltColor       cpAppAltColor "\x07\x07\x07\x07\x07\x07\x07\x07\x07"
#define cpDefColor          cpAppColor "\x07\x07\x07\x07\x07\x07\x07\x07\x07"
#define cpDefBlackWhite     cpAppBlackWhite "\x07\x07\x07\x07\x07\x07\x07\x07\x07"
#define cpDefMonochrome     cpAppMonochrome "\x07\x07\x07\x07\x07\x07\x07\x07\x07"

#endif

// Define the default size.  Doesn't matter which one we use because they are
// all the same size.
#define cpDefSize           sizeof(cpDefColor) - 1  // Less 1 for the NULL!

// ****************************************************************************
// ^^^^^^     NOTHING ABOVE THIS POINT WILL EVER CHANGE AND MUST NOT     ^^^^^^
//                     (Unless you add more color palettes)
// ****************************************************************************
//
// Extended color definitions:
//
// 1. TColorText additional color attributes.
//
#define cpColorTextAltColor   "\x1B\x1F\x4F\x4E"    // Alt color palette
#define cpColorTextColor      "\x1B\x1F\x4F\x4E"    // Color palette
#define cpColorTextBlackWhite "\x70\x7F\x07\x0F"    // B&W palette
#define cpColorTextMonochrome "\x70\x01\x0F\x0F"    // Monochrome palette

// 2. Define the indices into the extended application palettes.
//
#define cCTxtInfoColor      cpDefSize + 1       // Information color
#define cCTxtNotifyColor    cpDefSize + 2       // Notification color
#define cCTxtWarnColor      cpDefSize + 3       // Warning color
#define cCTxtErrorColor     cpDefSize + 4       // Error color

// ****************************************************************************
// vvvvvv       Additional extended color definitions will go here       vvvvvv
// ****************************************************************************
// TMsgViewWindow and TMsgListViewer

#define cpMsgDlgAltColor   "\x48\x4E\x4F\x74\x74\x4F\x6E\x4E"
#define cpMsgDlgColor      "\x48\x4E\x4F\x74\x74\x4F\x6E\x4E"
#define cpMsgDlgBlackWhite "\x78\x7F\x7F\x70\x70\x70\x07\x7F"
#define cpMsgDlgMonochrome "\x70\x70\x0F\x0F\x0F\x70\x0F\x01"

#define cMsgFramePassive    cCTxtErrorColor + 1   // Frame passive
#define cMsgFrameActive     cCTxtErrorColor + 2   // Frame active
#define cMsgFrameIcon       cCTxtErrorColor + 3   // Frame icons
#define cMsgSBPage          cCTxtErrorColor + 4   // Scrollbar page
#define cMsgSBCtrl          cCTxtErrorColor + 5   // Scrollbar controls
#define cMsgNText           cCTxtErrorColor + 6   // Normal text
#define cMsgSText           cCTxtErrorColor + 7   // Selected/Focused text
#define cMsgSelected        cCTxtErrorColor + 8   // Selected (inactive) text

// TVMIndicator
#define cpIndAltColor      "\x60\x7F"
#define cpIndColor         "\x30\x7F"
#define cpIndBlackWhite    "\x70\x70"
#define cpIndMonochrome    "\x70\x70"

#define cIndEditWin        cMsgSelected + 1       // For Edit Windows
#define cIndMemoFld        cMsgSelected + 2       // For Memo Fields

// ****************************************************************************
// ^^^^^^       ALWAYS ADD ANY NEW DEFINITIONS JUST ABOVE THIS LINE      ^^^^^^
// ****************************************************************************
//
// 3. Define the full extended color sets.
//    NOTE: THESE DEFINES SHOULD ALWAYS BE HERE AT THE BOTTOM AND NOWHERE ELSE!
// ****************************************************************************

#define cpExtAltColor       cpDefAltColor cpColorTextAltColor \
                            cpMsgDlgAltColor cpIndAltColor

#define cpExtColor          cpDefColor cpColorTextColor cpMsgDlgColor \
                            cpIndColor

#define cpExtBlackWhite     cpDefBlackWhite cpColorTextBlackWhite \
                            cpMsgDlgBlackWhite cpIndBlackWhite

#define cpExtMonochrome     cpDefMonochrome cpColorTextMonochrome \
                            cpMsgDlgMonochrome cpIndMonochrome

#endif // __TVCOLR_H
