// File    : DEMO.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Sat 07/23/94 11:28:07
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// Header file for the TVCOLR modifications demo.
//

// Miscellaneous definitions.

const int
    cmAbout         = 100,      // Standard event values.
    cmRepaint       = 101,
    cmColors        = 102,
    cmChangePalettes = 103,
    cmLoadCfg       = 104,
    cmSaveCfg       = 105,
    cmCloseTileable = 106,
    cmScreenSize    = 107,
    cmUserScreen    = 108,

    cmBlueWindow    = 109,       // Other command values.
    cmGrayWindow    = 110,
    cmCyanWindow    = 111,
    cmGrayDialogBox = 112,
    cmBlueDialogBox = 113,
    cmCyanDialogBox = 114,
    cmHelpWindow    = 115,
    cmMakeStrings   = 116,
    cmButton1       = 117,
    cmButton2       = 118,
    cmButton3       = 119;

#if defined(Uses_DemoApp)

// Exit code values.
#define EXIT_NOERR      0
#define EXIT_RSCERR     1
#define EXIT_SYNTAX     2
#define EXIT_SWERR      3

class _FAR TDeskTop;
class _FAR TDialog;
class _FAR TEvent;
class _FAR TMenuBar;
class _FAR TStatusLine;
class _FAR TPalette;
//class _FAR THeapView;
class _FAR TDemoHelpWindow;

// Class declarations.
class TDemoApp : public TApplication
{
public:
    TDemoApp(void);
    static TMenuBar *initMenuBar(TRect r);
    static TStatusLine *initStatusLine(TRect r);
    static TDeskTop *initDeskTop(TRect r);

    virtual void initScreen();                  // Sets correct palette.
    virtual void idle(void);
    virtual void handleEvent(TEvent& Event);
    virtual void outOfMemory(void);
    virtual TPalette& getPalette() const;

    void loadConfig(Boolean UseFileSetting);
    void saveConfig(void);

// ***************************************************************************
    TWindow *createDemoWindow(char *aTitle, ushort palette);
    TDemoHelpWindow *createDemoHelpWindow(void);
    TDialog *createShowColorDialog(ushort palette);
};

// A couple of useful functions.
Boolean isTileable(TView *p, void *);

// ***************************************************************************
// Interior class for displaying window colors.
class TInterior : public TView
{
public:
    TInterior(TRect &r) : TView(r) {};
    virtual void draw(void);
};

// Window for demonstrating the help window colors to insure they are
// still in the right place.
class TDemoHelpWindow : public TWindow
{
public:
    TDemoHelpWindow(TRect &r) :
       TWindow(r, "Help Window", wnNoNumber),
       TWindowInit( &TDemoHelpWindow::initFrame) {};

    virtual TPalette& getPalette() const;
};

// Interior class for displaying help window colors.
class THelpInterior : public TView
{
public:
    THelpInterior(TRect &r) : TView(r) {};
    virtual void draw(void);
    virtual TPalette& getPalette() const;
};

#endif
