// File    : DEMO.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Sat 07/23/94 14:12:22
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This program demonstrates the changes described in the TVCOLR.DOC and
// COLUPDT.DOC files.
//
// Note:  Compiling this program before making the described changes
// will generate an executable equivalent to DEMOUMOD.EXE.  Compiling this
// program after making the changes will generate an executable equivalent
// to DEMOMOD.EXE.
//
// Included is my standard front end.  It will also serve as a fairly good
// tutorial on selecting color palettes from the command line as well as
// saving and restoring colors to a configuration file.
//
// You may use any of the following command line parameters:
//
//     /MC | /MB | /MM | /MA    -  Select color, black & white, monochrome,
//                                 or alternate color palette.  If not
//                                 specified, it defaults to the palette
//                                 best suited for the monitor in use.
//
//     /Cdr:\path\filename.ext  -  Specify different default config filename.
//
//     /Rdr:\path\filename.ext  -  Specify different resource filename.
//
// This program uses a resource file for some of the objects like the menu
// bar, status line, color dialog box, etc.  If you use this code elsewhere
// without a resource file, you can generally replace the rsc->get() calls
// with calls to the functions from BLDRSC.CPP that create the objects.  Just
// include those functions in here or in a separate module and remove all
// references to the resource file.
//

#define FINAL            // Uncomment this line to allow searching the
                         // the end of the executable for the resource file.

#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <float.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//extern unsigned _stklen = 10240U;

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TColorDialog
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TFileDialog
#define Uses_THistory
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TListBox
#define Uses_TMemo
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TPalette
#define Uses_TRadioButtons
#define Uses_TResourceFile
#define Uses_TScreen
#define Uses_TScrollBar
#define Uses_TSItem
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#define Uses_TWindow
#define Uses_TVCOLR         // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

//#include <heapview.h>

// ****************************************************************************
// Headers not in the standard front end file.

#include <tcoltxt.h>           // TColorText header file.

#define Uses_DemoApp
#include "demo.h"              // Demo program header file.

// ****************************************************************************

#include "link.h"           // Resource file link definitions.

//extern int    _Cdecl _argc;  // Global pointers to the command line args.
//extern char **_Cdecl _argv;  // This way the app's constructor can access
                               // them.  Declarations are in DOS.H too.

extern TPoint shadowSize;   // Altered when screen size changes.

char demo_cfg[MAXPATH],     // Configuration filename.
     demo_rsc[MAXPATH];     // Resource filename.

// Resource file pointers.
fpstream *s;
TResourceFile *rsc = NULL;  // NULL to start with.

// The value of this variable determines what is printed when the program
// exits back to DOS.
short ExitValue = EXIT_NOERR;

// Monitor type palette index as set from the command line (/MC | /MB | /MM |
// /MA).  By default it is -1 to let the application use the default palette
// selected by TProgram::initScreen().
short CmdLinePalette = -1;

// Global pointer to the user screen buffer for the User Screen event.
char *ScrBuf = NULL;

// ****************************************************************************
// Global variables not in the standard front end file.

//  NONE

//*****************************************************************************
// Standard functions.  Modify as needed.

void exitfunc(void)
{
    switch(ExitValue)
    {
        case EXIT_NOERR:
            cout << endl << "Thank you for using this demo program." << endl;
            break;

        case EXIT_RSCERR:
            cout << "Could not locate or open resource file: " <<
                demo_rsc << endl;
            break;

        case EXIT_SWERR:
            cout << "Bad parameter: " << _argv[_argc] << endl << endl;
            // Fall through and display command line syntax.

        case EXIT_SYNTAX:
            cout << "Command line syntax:" << endl << _argv[0] <<
                " [/MC | /MB | /MC /MA] [/Rrsc_file.ext] [/Ccfg_file.ext]" <<
                endl;
            break;
    }
}

//
// This will kick everything off.  Note that no argc, or argv parameters are
// used.  The global _argc and _argv variables are used instead so that we
// don't have to pass them to the constructor.  You don't need to do things
// this way, it's just one alternative.
//
void main(void)
{
    short index = 1;

    // Supress TV's clearing of the screen at program end and register the
    // exit function.
    TScreen::clearOnSuspend = False;
    atexit(exitfunc);

    // To begin with, assume that the resource file is appended to the
    // executable.  If it isn't, we'll try a different approach.
    // To append the resource file to the executable you would issue the
    // command:
    //          COPY /B filename1.EXE+filename.RSC filename2.EXE
    //
    // Make sure the destination .EXE name is not the same as the source
    // .EXE name or you will overwrite the source .EXE file.
    // Also note that the source .EXE can't have debug info at the end of it.
    //
    strcpy(demo_rsc, _argv[0]);

// Until the final production version, don't bother trying to access the
// executable.  Debugging from within the IDE will cause a general access
// failure on the drive when it tries to open it.  TResourceFile won't
// read past the debug info at the end of the executable anyway so use a
// separate resource file until debugging is all done.
#ifndef FINAL
    strcpy(strrchr(demo_rsc, '.') + 1, "RSC");
#endif

    // Modify executable name to get location and name of the default
    // configuration file.  We'll assume the config file (if any) is in the
    // same directory as the executable and has the same name with a .CFG
    // extension.  It can be changed with a /C command line switch to
    // specify a different path to it or a different name.

    strcpy(demo_cfg, _argv[0]);
    strcpy(strrchr(demo_cfg, '.') + 1, "CFG");

    // Look for command line switches affecting configuration and resource
    // files.  A check for a user requested palette is also included here.
    // That way everything will come up in the proper colors when
    // setScreenMode() is called in the application's constructor or in
    // the loadConfig() function.
    //
    // I've found it best to scan for and process these items here because
    // I do have some cases where the command line arguments are processed
    // in the application's constructor to insert some default objects into
    // the desktop such as file or directory viewers, editor windows, etc
    // specified with other command line switches.  If there is an error
    // doing one of them, you need the screen active so that you can see
    // the error message box.  Also, you don't have to do anything special
    // in the application's constructor to switch palettes if one of these
    // is found.
    //
    while(index != _argc)
    {
        // Allow -opt or /opt.
        if(_argv[index][0] == '/' || _argv[index][0] == '-')
            switch(toupper(_argv[index][1]))
            {
                case 'M':       // Change the default palette.
                    switch(toupper(_argv[index][2]))
                    {
                        case 'C':
                            CmdLinePalette = apColor;
                            break;

                        case 'B':
                            CmdLinePalette = apBlackWhite;
                            break;

                        case 'M':
                            CmdLinePalette = apMonochrome;
                            break;

                        case 'A':
                            CmdLinePalette = apAltColor;
                            break;

                        default:
                            ExitValue = EXIT_SWERR;  // Signal bad switch value.
                            _argc = index;
                            exit(EXIT_SWERR);
                            break;
                    }
                    break;

                case 'C':           // Use a different configuration filename.
                    strcpy(demo_cfg, &_argv[index][2]);
                    break;

                case 'R':           // Use a different resource filename.
                    strcpy(demo_rsc, &_argv[index][2]);
                    break;

                case '?':
                    ExitValue = EXIT_SYNTAX;    // Display command syntax.
                    exit(EXIT_SYNTAX);
                    break;

//                case 'X':         // Ignore other valid switches that
//                case 'Y':         // will be processed in the application's
//                case 'Z':         // constructor.
//                    break;

                default:
                    ExitValue = EXIT_SWERR;  // Signal bad switch value.
                    _argc = index;
                    exit(EXIT_SWERR);
                    break;
            }

        index++;
    }

    // Now try to open the resource file and use it.
    s = new fpstream(demo_rsc, ios::in | ios::nocreate | ios::binary);
    if(s->good())
    {
        rsc = (TResourceFile *)new TResourceFile(s);

        if(!rsc->count())
        {
            TObject::destroy(rsc);      // No resource file in the EXE or
            rsc = NULL;                 // user supplied filename.
        }
    }
    else
        delete s;

    if(!rsc)
    {
        // As long as a /R switch wasn't specified, modify the executable name
        // to get the location and name of the default resource file.
        // We'll assume the resource file is in the same directory as the
        // executable and has the same name with a .RSC extension.  It can be
        // changed with a /R command line switch to specify a different path
        // to it or a different name.  If that is the case, it wasn't
        // accessible.
        if(!strnicmp(_argv[0], demo_rsc, strlen(_argv[0]) - 3))
        {
            strcpy(strrchr(demo_rsc, '.') + 1, "RSC");
            s = new fpstream(demo_rsc, ios::in | ios::nocreate | ios::binary);

            if(!s->good())
                ExitValue = EXIT_RSCERR;      // Still not accessible.
            else
            {
                rsc = (TResourceFile *)new TResourceFile(s);
                if(!rsc->count())
                {
                    TObject::destroy(rsc);      // Not a valid resource file.
                    ExitValue = EXIT_RSCERR;
                }
            }
        }
        else
            ExitValue = EXIT_RSCERR;   // User specified file isn't accessible.

        if(ExitValue)
            exit(EXIT_RSCERR);
    }

    // Okay, we're past the section that requires the orignal screen, so
    // it's okay for TV to clear it on suspend now.
    TScreen::clearOnSuspend = True;

    // Application Instance.  Change class name of application as needed.
    TDemoApp Demo;
    Demo.run();

    // Shutdown the app and close the resource file.
    Demo.shutDown();
    TObject::destroy(rsc);

    if(ScrBuf)
        delete [] ScrBuf;     // Delete User Screen buffer if used.

    exit(EXIT_NOERR);
}

// ****************************************************************************
// Standard front end functions follow, modify as needed.

//
// Constructor for the application.
//
TDemoApp::TDemoApp(void) :
  TProgInit( &TDemoApp::initStatusLine, &TDemoApp::initMenuBar,
    &TDemoApp::initDeskTop )
{
    TRect  r;
    TEvent event;
    short  index = 1,
           Ignored = 0;        // Count of ignored command line parameters.


    TScreen::checkSnow = False;        // Insure snow checking is off.

//    // Create the heap view (optional).
//    r = getExtent();
//    r.a.x = r.b.x - 21;
//    r.b.y = r.a.y + 1;
//    heap = new THeapView( r );
//    insert(heap);

    // **********************************************************************
    // Application-specific setup code.

    // NONE

    // **********************************************************************
    // All the default objects and views have been constructed, now we
    // can do some stuff with the desktop.

    // If there is a configuration file, read in the data now.
    // Then, here or in loadConfig, turn on the screen and redraw it.
    // If it is done earlier than this, the proper colors won't be used
    // for the initial screen when an alternate palette is specified.
    if(!access(demo_cfg, 0))
        loadConfig(False);
    else
        setScreenMode(TScreen::screenMode);

    // **********************************************************************

    // Process any other command line arguments now.
    // Don't forget to ignore any of the one's parsed in main().
    while(index != _argc)
    {
        if(_argv[index][0] == '/' || _argv[index][0] == '-')
        {
            switch(toupper(_argv[index][1]))
            {
//                case 'X':
//                case 'Y':
//                case 'Z':
//                    do something
//                    break;

                case 'C':                  // Ignore config file selection
                case 'R':                  // Ignore resource file selection.
                case 'M':                  // Ignore palette selection.
                    Ignored++;             // They're already taken care of.
                    break;

                default:
                    Ignored++;
                    messageBox(mfError | mfOKButton,
                        "Invalid command line switch: %s", _argv[index]);
                    break;
            }
        }
        else  // If not a switch, default to doing something else with it.
        {
            // Ignored by default.
            Ignored++;
            messageBox(mfError | mfOKButton,
                "Invalid command line parameter: %s", _argv[index]);
        }

//      Processing to be done after each switch command (if any).
//      Insert default views, etc.

        index++;
    }

    // Display the About Box if no command line parameters are passed
    // or only /Mx, /C, or /R parameters were used.
    if(_argc < 2 || (_argc - Ignored) < 2)
    {
        event.what = evCommand;
        event.message.command = cmAbout;
        putEvent(event);
    }
}

// This is where the palettes for the application are defined.
TPalette &TDemoApp::getPalette() const
{
    // The Color and Alternate Color attribute maps are swapped in these
    // definitions so that my color preferences are used by default for
    // color monitors.

    static TPalette color( cpExtAltColor, sizeof( cpExtAltColor)-1 );
    static TPalette blackwhite( cpExtBlackWhite, sizeof( cpExtBlackWhite)-1 );
    static TPalette monochrome( cpExtMonochrome, sizeof( cpExtMonochrome)-1 );
    static TPalette altcolor( cpExtColor, sizeof( cpExtColor)-1 );

    static TPalette *palettes[] =
    {
        &color,
        &blackwhite,
        &monochrome,
        &altcolor        // Additional palettes must come after standard ones
                         // in this array.
    };
    return *(palettes[appPalette]);
}

//
// Desktop initialization.
//
TDeskTop *TDemoApp::initDeskTop(TRect r)
{
    // Prevent drawing the desktop until the colors are set correctly.
    TProgram::application->setState(sfExposed, False);

    r.a.y++;
    r.b.y--;
    return new TDeskTop(r);
}

//
// Screen initialization.  This is overridden so that a command line
// specified color palette can be used.  If not, the default initScreen()
// will reset the palette based on monitor type every time it is called.
//
void TDemoApp::initScreen()
{
    TProgram::initScreen();

    // Force palette to equal the user-specified palette.
    if(CmdLinePalette > -1 && TApplication::appPalette != CmdLinePalette)
    {
        TApplication::appPalette = CmdLinePalette;

        // If monochrome, turn off shadows and turn on markers.
        if(CmdLinePalette == apMonochrome)
        {
            shadowSize.x = 0;
            shadowSize.y = 0;
            showMarkers = True;
        }
    }
}

//
// Menubar initialization.
//
TMenuBar *TDemoApp::initMenuBar(TRect)
{
    return (TMenuBar *)rsc->get("MenuBar");
}

//
// Create statusline.
//
TStatusLine *TDemoApp::initStatusLine( TRect )
{
    TStatusLine *statLine = (TStatusLine *)rsc->get("StatusLine");

    // If the application starts up in anything other than a screen mode
    // of 25 lines, the status bar will end up in the wrong place.
    if(statLine->origin.y != TScreen::screenHeight - 1)
        statLine->origin.y = TScreen::screenHeight - 1;

    return statLine;
}

//
// Application idle function.  Modify or remark out as required.
//
void TDemoApp::idle(void)
{
      TProgram::idle();
//    heap->update();
//
    // Turn off Tile and Cascade if other window commands are disabled.
    if(!commandEnabled(cmPrev))
    {
        disableCommand(cmCloseTileable);
        disableCommand(cmTile);
        disableCommand(cmCascade);
    }
    else
    {
        enableCommand(cmCloseTileable);
        enableCommand(cmTile);
        enableCommand(cmCascade);
    }

    // Select the menu bar if the desktop is empty.
    if(!deskTop->current && !menuBar->getState(sfSelected))
    {
        TEvent event;
        event.what = evCommand;
        event.message.command = cmMenu;
        putEvent(event);
    }
}

//
//  Event handler to distribute the work.
//
void TDemoApp::handleEvent(TEvent &event)
{
    FILE    *palfp;
    TView   *vw;
    TColorDialog *c;

    short    newMode;

    TApplication::handleEvent(event);

    if(event.what == evCommand)
    {
        switch(event.message.command)
        {
    // Standard front end evCommand events.

            case cmAbout:               //  About Dialog Box
                executeDialog((TDialog *)rsc->get("AboutBox"), NULL);
                break;

            case cmRepaint:
                setScreenMode(TScreen::screenMode);
                break;

//            case cmSaveAll:
//                // Change it from a command to a broadcast event.
//                message(deskTop, evBroadcast, cmSaveAll, NULL);
//                break;
//
            case cmDosShell:
                suspend();          // Suspend Turbo Vision and shell to DOS.
                cout << endl << "Type EXIT to return..." << endl;
                system("");
                _fpreset();         // Reset math co-processor.

                if(!ScrBuf)
                    ScrBuf = new char[4100];    // At least 4000 bytes.

                gettext(1, 1, 80, 25, ScrBuf);  // Get screen image.

                resume();       // Restart Turbo Vision.
                redraw();
                break;

            case cmTile:                //  Tile current windows
                deskTop->tile(deskTop->getExtent());
                break;

            case cmCascade:             //  Cascade current windows
                deskTop->cascade(deskTop->getExtent());
                break;

            case cmCloseTileable:  // Close all views that have ofTileable set.
                while((vw = deskTop->firstThat(isTileable, 0)) != NULL)
                    message(vw, evCommand, cmClose, NULL);
                break;

            case cmScreenSize:          // Change screen size.
                newMode = TScreen::screenMode ^ TDisplay::smFont8x8;

                if(newMode & TDisplay::smFont8x8)
                    shadowSize.x = 1;
                else
                    shadowSize.x = 2;

                setScreenMode(newMode);
                break;

            case cmUserScreen:
                suspend();      // Suspend Turbo Vision and display user
                if(ScrBuf)      // screen if there is one.
                    puttext(1, 1, 80, 25, ScrBuf);

                getch();        // Wait for keypress and restart Turbo Vision.
                resume();
                redraw();
                break;

            case cmColors:
//                c = (TColorDialog *)Colors();
                c = (TColorDialog *)rsc->get("ColorDlg");

                if(validView(c))
                {
                    // NOTE: Don't use a temporary palette anymore!
                    // TColorDialog has been fixed in TV 2.0 and it
                    // doesn't need it!
                    c->setData(&getPalette());      // Call setData() with
                                                    // the initial colors.
                    // Execute the color dialog box.
                    if(deskTop->execView(c) != cmCancel)
                    {
                        // Do a straight assignment to get the modified colors.
                        getPalette() = *(c->pal);

                        // Repaint the entire desktop by calling
                        // setScreenMode().  Calling deskTop->setState()
                        // to set sfVisible off and then on as in TVDEMO
                        // doesn't always redraw the entire screen if
                        // there is a window or some other view on the
                        // desktop that has the focus.
                        setScreenMode(TScreen::screenMode);
                    }
                    destroy(c);
                }
                break;

            case cmChangePalettes:
                CmdLinePalette = appPalette + 1;

                if(CmdLinePalette == apTotalPalettes)
                    CmdLinePalette = apColor;

                setScreenMode(TScreen::screenMode);
                break;

            case cmLoadCfg:
                if(executeDialog(new TFileDialog(demo_cfg, "Load Configuration",
                  "~N~ame", fdOpenButton, 100), demo_cfg) != cmCancel)
                    loadConfig(True);
                break;

            case cmSaveCfg:
                if(executeDialog(new TFileDialog(demo_cfg, "Save Configuration",
                  "~N~ame", fdOKButton, 100), demo_cfg) != cmCancel)
                    saveConfig();
                break;

    // Non-standard evCommand events.
            case cmMakeStrings:
                // This creates a text file containing #defines for
                // all palettes as currently configured.  Use it for
                // creating your own custom palette replacement for
                // cpAltColor, cpColor, cpBlackWhite, cpMonochrome,
                // the help palettes, or your custom object palettes.
                palfp = fopen("PALETTE.DEF", "wt");
                if(palfp)
                {
                    short save_palette = appPalette;
                    fputs("// For each palette:\n// Lines 1-11 = Standard "
                          "palette\n// Line 12-??? = All other color "
                          "palettes\n", palfp);

                    for(short i = 0; i < apTotalPalettes; i++)
                    {
                        appPalette = i;     // Get palette information.
                        TPalette *cpal = &getPalette();
                        uchar *palptr = (uchar *)cpal->data;

                        switch(i)
                        {
                            case 0:
                                fputs("\n#define AllColor \\\n", palfp);
                                break;

                            case 1:
                                fputs("\n#define AllBlackWhite \\\n", palfp);
                                break;

                            case 2:
                                fputs("\n#define AllMonochrome \\\n", palfp);
                                break;

                            default:
                                fprintf(palfp, "\n#define AllOther_%d\\\n", i);
                                break;
                        }

                        short len = *palptr++, index = 0;
                        while(index != len)
                        {
                            fputs("    \"", palfp);
                            for(short byte = 0; (byte < 14 || index == 127) &&
                              index != len; byte++, index++)
                            {
                                fprintf(palfp, "\\x%02X", (ushort)*palptr++);

                                // Separate standard palette and user's
                                // object palettes.
                                if(index == sizeof(cpAppColor) - 2)
                                {
                                    index++;
                                    break;
                                }
                            }

                            if(index != len)
                                fputs("\" \\\n", palfp);
                        }
                        fprintf(palfp,"\"\n");
                    }
                    fclose(palfp);

                    appPalette = save_palette;
                }
                break;

            case cmBlueWindow:
                insertWindow(createDemoWindow("Blue Window", wpBlueWindow));
                break;

            case cmGrayWindow:
                insertWindow(createDemoWindow("Gray Window", wpGrayWindow));
                break;

            case cmCyanWindow:
                insertWindow(createDemoWindow("Cyan Window", wpCyanWindow));
                break;

            case cmGrayDialogBox:
                insertWindow(createShowColorDialog(dpGrayDialog));
                break;

            case cmBlueDialogBox:
                insertWindow(createShowColorDialog(dpBlueDialog));
                break;

            case cmCyanDialogBox:
                insertWindow(createShowColorDialog(dpCyanDialog));
                break;

            case cmHelpWindow:
                insertWindow(createDemoHelpWindow());
                break;

            default:
                return;
        }
        clearEvent (event);
    }
}

// Standard Out Of Memory error dialog.
void TDemoApp::outOfMemory(void)
{
    messageBox("Not enough memory for this operation.", mfError | mfCancelButton);
}

//
// Standard load config file.  Modify as needed.
//
void TDemoApp::loadConfig(Boolean UseFileSetting)
{
    fpstream *f = new fpstream(demo_cfg, ios::in | ios::nocreate | ios::binary);

    if(!f->good())
    {
        //  Turn on the screen?
        if(!(state & sfExposed))
            setScreenMode(TScreen::screenMode);

        messageBox(mfError | mfOKButton,
            "Could not open configuration file: %s", demo_cfg);

        delete f;
        return;
    }

    ipstream &strm = *f;

    // Read palettes from the configuration file.
    short curr_palette = appPalette;
    for(short i = 0; i < apTotalPalettes; i++)
    {
        appPalette = i;
        TPalette *palette = &getPalette();
        strm.readBytes(palette->data, palette->data[0] + 1);
    }
    appPalette = curr_palette;

    // Get the video mode
    ushort scrMode;
    strm.readBytes(&scrMode, sizeof(scrMode));

    // Get the palette that was in use.
    short usePalette;
    strm.readBytes(&usePalette, sizeof(usePalette));

    // If not overridden from the command line, set the palette.
    if(CmdLinePalette == -1 || (CmdLinePalette != -1 && UseFileSetting))
        CmdLinePalette = usePalette;

    if(scrMode & TDisplay::smFont8x8)
        shadowSize.x = 1;
    else
        shadowSize.x = 2;

    setScreenMode(scrMode);

    // ************************************************************************
    // Add code here to load non-standard application-specific config data.

    delete f;
}

//
// Standard save config file.  Modify as needed.
//
void TDemoApp::saveConfig(void)
{
    fpstream *f = new fpstream(demo_cfg, ios::trunc | ios::binary);

    if(!f->good())
    {
        messageBox(mfError | mfOKButton,
            "Could not open configuration file: %s", demo_cfg);

        delete f;
        return;
    }

    opstream &strm = *f;

    // Store the palettes
    short curr_palette = appPalette;
    for(short i = 0; i < apTotalPalettes; i++)
    {
        appPalette = i;
        TPalette *palette = &getPalette();
        strm.writeBytes(palette->data, palette->data[0] + 1);
    }
    appPalette = curr_palette;

    // Store current video mode
    strm.writeBytes(&TScreen::screenMode, sizeof(TScreen::screenMode));

    // Store current palette in use.
    strm.writeBytes(&appPalette, sizeof(appPalette));

    // ************************************************************************
    // Add code here to save non-standard application-specific config data.

    delete f;
}

// ****************************************************************************
//
// The isTileable() function checks for a tileable view on the desktop.
//
Boolean isTileable(TView *p, void *)
{
    // Must ignore objects such as the clipboard when they are hidden!
    if(!(p->options & ofTileable) || !(p->state & sfVisible))
        return False;

    return True;
}

// ****************************************************************************
// End of standard front end functions.
// ****************************************************************************
// Other functions not in the standard front end file.

// ****************************************************************************
// Create a demo window to view the colors.
TWindow *TDemoApp::createDemoWindow(char *aTitle, ushort palette)
{
    randomize();

    // Randomly select an initial size and position.
    TRect r(0, 0, 34, 6);
    r.move(rand() % 30, rand() % 10);

    TWindow *win = new TWindow(r, aTitle, 0);

    if(!win)
        return NULL;

    win->palette = palette;
    win->options |= ofTileable;     // Allow it to cascade/tile.

    win->standardScrollBar(sbVertical);
    r = win->getClipRect();
    r.grow(-1,-1);

    TInterior *i = new TInterior(r);
    i->growMode = gfGrowHiX | gfGrowHiY;
    win->insert(i);
    return win;
}

// Create a demo dialog to show the object colors
TDialog *TDemoApp::createShowColorDialog(ushort palette)
{
    TDialog* dlg = new TDialog(TRect(3 + palette, 1, 71 + palette, 23),
        "Show Object Colors");
    if(!dlg)
        return NULL;

    dlg->palette = palette;

    dlg->insert(new TColorText(TRect(3, 2, 14, 3), "Normal Text", eTxtNormal));
    dlg->insert(new TColorText(TRect(3, 4, 19, 5), "Information Text", eTxtInfo));
    dlg->insert(new TColorText(TRect(3, 6, 20, 7), "Notification Text", eTxtNotify));
    dlg->insert(new TColorText(TRect(3, 8, 15, 9), "Warning Text", eTxtWarn));
    dlg->insert(new TColorText(TRect(3, 10, 13, 11), "Error Text", eTxtError));

    TInputLine *l = new TInputLine(TRect(38, 2, 50, 3), 11);
    dlg->insert(l);
    dlg->insert(new TLabel(TRect(30, 2, 37, 3), "~L~abel:", l));
    dlg->insert(new THistory(TRect(50, 2, 53, 3), l, 10));

    TCheckBoxes *c = new TCheckBoxes(TRect(30, 4, 52, 6),
      new TSItem("Checkbox #1",
      new TSItem("Checkbox #2", 0)));
    dlg->insert(c);

    TRadioButtons *r = new TRadioButtons(TRect(30, 7, 52, 9),
        new TSItem("Radio button #1",
        new TSItem("Radio button #2", 0)));
    dlg->insert(r);

    TScrollBar *lbsb = new TScrollBar(TRect(26, 12, 27, 17));
    dlg->insert(lbsb);
    TListBox *lb = new TListBox(TRect(3, 12, 26, 17), 2, lbsb);
    dlg->insert(lb);

    TScrollBar *vsb = new TScrollBar(TRect(64, 11, 65, 17));
    dlg->insert(vsb);
    TScrollBar *hsb = new TScrollBar(TRect(30, 17, 64, 18));
    dlg->insert(hsb);
    TMemo *memo = new TMemo(TRect(30, 11, 64, 17), hsb, vsb, 0, 255);
    dlg->insert(memo);

    dlg->insert(new TButton(TRect(3, 19, 21, 21), "~D~efault Button",
        cmButton1, bfDefault));
    dlg->insert(new TButton(TRect(24, 19, 42, 21), "~E~nabled Button",
        cmButton2, bfNormal));
    dlg->insert(new TButton(TRect(45, 19, 64, 21), "D~i~sabled Button",
        cmButton3, bfNormal));

    disableCommand(cmButton3);
    dlg->selectNext(False);
    return dlg;
}

// Create a demo help window to view the colors.
TDemoHelpWindow *TDemoApp::createDemoHelpWindow(void)
{
    // Randomly select an initial size and position.
    TRect r(0, 0, 34, 7);
    r.move(rand() % 30, rand() % 10);

    TDemoHelpWindow *hlp = new TDemoHelpWindow(r);

    if(!hlp)
        return NULL;

    randomize();

    hlp->standardScrollBar(sbVertical);

    r = hlp->getClipRect();
    r.grow(-1,-1);
    THelpInterior *hi = new THelpInterior(r);
    hi->growMode = gfGrowHiX | gfGrowHiY;
    hlp->insert(hi);
    return hlp;
}

void TInterior::draw(void)
{
    // A simple demo to display all window colors colors.
    TView::draw();

    TDrawBuffer b;
    ushort color = getColor(0x0706);

    b.moveChar(0, ' ', color, size.x);
    b.moveCStr( 0, "Normal Text    ~Selected Text~", color );
    writeLine( 2, 1, 28, 1, b);
}

TPalette &TDemoHelpWindow::getPalette() const
{
    static TPalette palette(cHelpWindow, sizeof( cHelpWindow)-1);
    return palette;
}

void THelpInterior::draw(void)
{
    // A simple demo to insure the help colors are in the right place.
    TView::draw();

    TDrawBuffer b;
    ushort color = getColor(0x0201);

    b.moveChar(0, ' ', color, size.x);
    b.moveCStr( 0, "Normal Text    ~Keyword~", color );
    writeLine( 2, 1, 22, 1, b);

    color = getColor(0x03);
    b.moveChar(0, ' ', color, 16);
    b.moveCStr( 0, "Selected keyword", color );
    writeLine( 2, 3, 16, 1, b);
}

TPalette &THelpInterior::getPalette() const
{
    static TPalette palette(cHelpViewer, sizeof( cHelpViewer)-1);
    return palette;
}

// ****************************************************************************
// End of standard front end file.
// ****************************************************************************
