// File    : BLDRSC.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Sat 07/23/94 11:25:55
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This file contains the standard resource file builder.
// Modify or add the necessary items and compile.
//

#define RSC_FILENAME    "DEMO.RSC"   // File to create.
                                     // Works for either demo.  Just specify
                                     // /RDEMO.RSC on its command line.

#define WriteResource(a,b,c) \
    cout << c << endl; \
    a = b(); \
    if( a == 0 ) \
    { \
        cout << endl << RSC_FILENAME << ": Creation failure" << endl; \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#define WriteObject(a,c) \
    cout << c << endl; \
    if(a == 0) \
    { \
        cout << endl << RSC_FILENAME << ": Creation failure" << endl; \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define Uses_TButton
#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TDialog
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TResourceFile
#define Uses_TScreen
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

#include <tcoltxt.h>

#include "link.h"           // Resource file link definitions.
#include "demo.h"

// ============================================================================
TDialog *Colors(void);
TDialog *AboutBox(void);

TMenuBar *initMenuBar(void);
TStatusLine *initStatusLine(void);

// ============================================================================

fpstream *s;
TResourceFile* rsc;

// ============================================================================

void main(void)
{
    TDialog *dlg;
    TMenuBar *menuBar;
    TStatusLine *statusLine;

    // Supress TV's clearing of the screen at program end.
    TScreen::clearOnSuspend = False;

    cout << "Creating " RSC_FILENAME << endl;

    // Construct stream and resource file.
    s = new fpstream (RSC_FILENAME, ios::trunc | ios::binary);
    rsc = new TResourceFile(s);

    // Create all of the necessary dialogs for the demo.
    WriteResource(dlg, AboutBox, "AboutBox");
    WriteResource(dlg, Colors, "ColorDlg");

    // Create the menus and status line.
    WriteResource(menuBar, initMenuBar, "MenuBar");
    WriteResource(statusLine, initStatusLine, "StatusLine");

    TObject::destroy(rsc);

    cout << endl << RSC_FILENAME << ": Creation completed" << endl;
}

// ============================================================================
TDialog *AboutBox(void)
{
    TDialog *aboutBox = new TDialog(TRect(0, 0, 46, 11), "About");
    aboutBox->options |= ofCentered;

    aboutBox->insert(new TColorText(TRect(1, 1, 45, 7),
            "\n\003TVCOLR/COLUPDT Changes Demo\n\003\n"
            "\003by Eric Woodruff\n\003CIS ID: 72134,1150\n", eTxtInfo));

    TButton *b = new TButton(TRect(11,8,23,10), "O~K~", cmOK, bfDefault);
    b->options |= ofCenterX;
    aboutBox->insert(b);

    return aboutBox;
}

TDialog *Colors(void)
{
    TColorGroup &group1 =
        *new TColorGroup("Desktop") +
            *new TColorItem("Background",        1)+

        *new TColorGroup("Menus") +
            *new TColorItem("Normal text",       2)+
            *new TColorItem("Disabled text",     3)+
            *new TColorItem("Shortcut key",      4)+
            *new TColorItem("Selection bar",     5)+
            *new TColorItem("Selected disabled", 6)+
            *new TColorItem("Shortcut selected", 7);

    TColorGroup &group2 =
        *new TColorGroup("Blue Window") +
            *new TColorItem("Frame inactive",    8)+
            *new TColorItem("Frame active",      9)+
            *new TColorItem("Frame icons",      10)+
            *new TColorItem("Scrollbar page",   11)+
            *new TColorItem("Scrollbar icons",  12)+
            *new TColorItem("Normal text",      13)+
            *new TColorItem("Selected text",    14)+

        *new TColorGroup("Cyan Window") +
            *new TColorItem("Frame inactive",  16)+
            *new TColorItem("Frame active",    17)+
            *new TColorItem("Frame icons",     18)+
            *new TColorItem("Scrollbar page",  19)+
            *new TColorItem("Scrollbar icons", 20)+
            *new TColorItem("Normal text",     21)+
            *new TColorItem("Selected text",   22)+

        *new TColorGroup("Gray Window") +
            *new TColorItem("Frame inactive",  24)+
            *new TColorItem("Frame active",    25)+
            *new TColorItem("Frame icons",     26)+
            *new TColorItem("Scrollbar page",  27)+
            *new TColorItem("Scrollbar icons", 28)+
            *new TColorItem("Normal text",     29)+
            *new TColorItem("Selected text",   30);

    TColorGroup &group3 =
        *new TColorGroup("Gray Dialog Box") +
            *new TColorItem("Frame inactive",   32)+
            *new TColorItem("Frame active",     33)+
            *new TColorItem("Frame icons",      34)+
            *new TColorItem("Scrollbar page",   35)+
            *new TColorItem("Scrollbar icons",  36)+

            *new TColorItem("Normal text",       37)+

        // Selected Shortcut is only applicable if you made the
        // changes described in COLUPDT.DOC in TVCLR2.ZIP.
            *new TColorItem("Normal label",            38)+
            *new TColorItem("Selected label",          39)+
            *new TColorItem("Label shortcut key",      40)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Selected label shortcut key", 138)+  // Added by me
#endif

        // Default and Selected Shortcut are only applicable if you made
        // the changes described in COLUPDT.DOC in TVCLR2.ZIP
            *new TColorItem("Normal button",            41)+
            *new TColorItem("Default button",           42)+
            *new TColorItem("Selected button",          43)+
            *new TColorItem("Disabled button",          44)+
            *new TColorItem("Button shortcut key",      45)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Default button shortcut key",  136)+ // Added by me
            *new TColorItem("Selected button shortcut key", 137)+ // Added by me
#endif
            *new TColorItem("Button shadow",            46)+

            *new TColorItem("Cluster normal",    47)+
            *new TColorItem("Cluster selected",  48)+
            *new TColorItem("Cluster shortcut",  49)+

            *new TColorItem("Input line normal",    50)+
            *new TColorItem("Input line selected",  51)+
            *new TColorItem("Input line arrow",     52)+
            *new TColorItem("History button",       53)+
            *new TColorItem("History sides",        54)+
            *new TColorItem("History scrollbar",    55)+
            *new TColorItem("History icons",        56)+

            *new TColorItem("Normal list item",     57)+
            *new TColorItem("Focused list item",    58)+
            *new TColorItem("Selected list item",   59)+
            *new TColorItem("List divider",         60)+
            *new TColorItem("Information pane",     61);

    TColorGroup &group4 =
        *new TColorGroup("Blue Dialog Box") +
            *new TColorItem("Frame inactive",   64)+
            *new TColorItem("Frame active",     65)+
            *new TColorItem("Frame icons",      66)+
            *new TColorItem("Scrollbar page",   67)+
            *new TColorItem("Scrollbar icons",  68)+

            *new TColorItem("Normal text",       69)+

        // Selected Shortcut is only applicable if you made the
        // changes described in COLUPDT.DOC in TVCLR2.ZIP.
            *new TColorItem("Normal label",            70)+
            *new TColorItem("Selected label",          71)+
            *new TColorItem("Label shortcut key",      72)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Selected label shortcut key", 141)+  // Added by me
#endif

        // Default and Selected Shortcut are only applicable if you made
        // the changes described in COLUPDT.DOC in TVCLR2.ZIP
            *new TColorItem("Normal button",            73)+
            *new TColorItem("Default button",           74)+
            *new TColorItem("Selected button",          75)+
            *new TColorItem("Disabled button",          76)+
            *new TColorItem("Button shortcut key",      77)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Default button shortcut key",  139)+ // Added by me
            *new TColorItem("Selected button shortcut key", 140)+ // Added by me
#endif
            *new TColorItem("Button shadow",            78)+

            *new TColorItem("Cluster normal",    79)+
            *new TColorItem("Cluster selected",  80)+
            *new TColorItem("Cluster shortcut",  81)+

            *new TColorItem("Input line normal",    82)+
            *new TColorItem("Input line selected",  83)+
            *new TColorItem("Input line arrow",     84)+
            *new TColorItem("History button",       85)+
            *new TColorItem("History sides",        86)+
            *new TColorItem("History scrollbar",    87)+
            *new TColorItem("History icons",        88)+

            *new TColorItem("Normal list item",     89)+
            *new TColorItem("Focused list item",    90)+
            *new TColorItem("Selected list item",   91)+
            *new TColorItem("List divider",         92)+
            *new TColorItem("Information pane",     93);

    TColorGroup &group5 =
        *new TColorGroup("Cyan Dialog Box") +
            *new TColorItem("Frame inactive",   96)+
            *new TColorItem("Frame active",     97)+
            *new TColorItem("Frame icons",      98)+
            *new TColorItem("Scrollbar page",   99)+
            *new TColorItem("Scrollbar icons", 100)+

            *new TColorItem("Normal text",      101)+

        // Selected Shortcut is only applicable if you made the
        // changes described in COLUPDT.DOC in TVCLR2.ZIP.
            *new TColorItem("Normal label",           102)+
            *new TColorItem("Selected label",         103)+
            *new TColorItem("Label shortcut key",     104)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Selected label shortcut key", 144)+  // Added by me
#endif

        // Default and Selected Shortcut are only applicable if you made
        // the changes described in COLUPDT.DOC in TVCLR2.ZIP
            *new TColorItem("Normal button",           105)+
            *new TColorItem("Default button",          106)+
            *new TColorItem("Selected button",         107)+
            *new TColorItem("Disabled button",         108)+
            *new TColorItem("Button shortcut key",     109)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Default button shortcut key",  142)+ // Added by me
            *new TColorItem("Selected button shortcut key", 143)+ // Added by me
#endif
            *new TColorItem("Button shadow",           110)+

            *new TColorItem("Cluster normal",   111)+
            *new TColorItem("Cluster selected", 112)+
            *new TColorItem("Cluster shortcut", 113)+

            *new TColorItem("Input line normal",   114)+
            *new TColorItem("Input line selected", 115)+
            *new TColorItem("Input line arrow",    116)+
            *new TColorItem("History button",      117)+
            *new TColorItem("History sides",       118)+
            *new TColorItem("History scrollbar",   119)+
            *new TColorItem("History icons",       120)+

            *new TColorItem("Normal list item",    121)+
            *new TColorItem("Focused list item",   122)+
            *new TColorItem("Selected list item",  123)+
            *new TColorItem("List divider",        124)+
            *new TColorItem("Information pane",    125);

    TColorGroup &group6 =
        *new TColorGroup("Help Window") +
            *new TColorItem("Frame inactive",   128)+
            *new TColorItem("Frame active",     129)+
            *new TColorItem("Frame icons",      130)+
            *new TColorItem("Scrollbar page",   131)+
            *new TColorItem("Scrollbar icons",  132)+
            *new TColorItem("Normal text",      133)+
            *new TColorItem("Keyword",          134)+
            *new TColorItem("Selected keyword", 135);

        // These four Dialog Text colors can be set, but are only
        // accessible when using the alternate mapColor() routine
        // from TVCLR2.ZIP.
    TColorGroup &group7 =
        *new TColorGroup("Notice Text") +
            *new TColorItem("Information text",  cCTxtInfoColor)+   // Extended
            *new TColorItem("Notification text", cCTxtNotifyColor)+ // Extended
            *new TColorItem("Warning text",      cCTxtWarnColor)+   // Extended
            *new TColorItem("Error text",        cCTxtErrorColor);  // Extended

    TColorGroup &All = group1 + group2 + group3 + group4 + group5 +
                        group6 + group7;

    // See the notes in handleEvent() about the proper usage of TColorDialog.
    TColorDialog *c = new TColorDialog((TPalette*)0, &All);

    return c;
}

TMenuBar *initMenuBar(void)
{
    TSubMenu& MiscMenu = *new TSubMenu( "~\xF0~", 0) +
        *new TMenuItem( "~A~bout...", cmAbout, kbNoKey)+
        *new TMenuItem( "~R~epaint desktop", cmRepaint, kbNoKey);

    TSubMenu& FileMenu = *new TSubMenu("~D~emo", 0) +
        *new TMenuItem( "Insert ~B~lue Window", cmBlueWindow, kbF2, hcNoContext, "F2" ) +
        *new TMenuItem( "Insert ~G~ray Window", cmGrayWindow, kbAltF2, hcNoContext, "Alt+F2" ) +
        *new TMenuItem( "Insert ~C~yan Window", cmCyanWindow, kbCtrlF2, hcNoContext, "Ctrl+F2" ) +
            newLine() +
        *new TMenuItem( "Insert Gray ~D~ialog Box",  cmGrayDialogBox,  kbF4, hcNoContext, "F4" ) +
        *new TMenuItem( "Insert Blue D~i~alog Box",  cmBlueDialogBox,  kbAltF4, hcNoContext, "Alt+F4" ) +
        *new TMenuItem( "Insert Cyan Di~a~log Box",  cmCyanDialogBox,  kbCtrlF4, hcNoContext, "Ctrl+F4" ) +
            newLine() +
        *new TMenuItem( "Insert ~H~elp Window", cmHelpWindow, kbF9, hcNoContext, "F9" ) +
            newLine() +
        *new TMenuItem( "~D~OS shell", cmDosShell, kbNoKey) +
        *new TMenuItem( "~Q~uit", cmQuit, kbAltX, hcNoContext, "Alt+X" );

    TSubMenu& WindowMenu = *new TSubMenu( "~W~indows", 0) +
        *new TMenuItem( "~S~ize/Move", cmResize, kbCtrlF5, hcNoContext, "Ctrl+F5" ) +
        *new TMenuItem( "~Z~oom", cmZoom, kbF5, hcNoContext, "F5" ) +
        *new TMenuItem( "C~a~scade", cmCascade, kbNoKey) +
        *new TMenuItem( "~T~ile", cmTile, kbNoKey) +
        *new TMenuItem( "Ne~x~t", cmNext, kbF6, hcNoContext, "F6" ) +
        *new TMenuItem( "~P~revious", cmPrev, kbShiftF6, hcNoContext, "Shift+F6" ) +
        *new TMenuItem( "~C~lose", cmClose, kbAltF3, hcNoContext, "Alt+F3" ) +
        *new TMenuItem( "Clos~e~ all", cmCloseTileable, kbNoKey) +
            newLine() +
        *new TMenuItem( "To~g~gle Screen Size", cmScreenSize, kbNoKey) +
        *new TMenuItem( "~U~ser screen", cmUserScreen, kbAltF5, hcNoContext, "Alt+F5");

    TSubMenu& OptionsMenu = *new TSubMenu("~O~ptions", 0) +
        *new TMenuItem( "~C~olors...", cmColors, kbNoKey ) +
        *new TMenuItem( "C~h~ange palettes", cmChangePalettes, kbNoKey ) +
        *new TMenuItem( "~M~ake palette strings text file", cmMakeStrings, kbNoKey) +
            newLine() +
        *new TMenuItem( "~L~oad configuration...", cmLoadCfg, kbNoKey) +
        *new TMenuItem( "~S~ave configuration...", cmSaveCfg, kbNoKey);

    return new TMenuBar(TRect(0, 0, 80, 1), MiscMenu + FileMenu +
        WindowMenu + OptionsMenu);
}

TStatusLine *initStatusLine(void)
{
    return new TStatusLine( TRect(0, 24, 80, 25),
      *new TStatusDef( 0, 0xFFFF ) +
        *new TStatusItem(0, kbF10, cmMenu) +
        *new TStatusItem( "~F1~ Help", kbF1, cmHelp ) +
        *new TStatusItem( "~Alt+X~ Exit", kbAltX, cmQuit ) +
        *new TStatusItem( "~Alt+F3~ Close", kbAltF3, cmClose));
}
